/**
 * Scripts within the customizer controls window.
 *
 * Contextually shows the color hue control and informs the preview
 * when users open or close the front page sections section.
 */

(function( $, api ) {
    wp.customize.bind('ready', function() {
    	// Show message on change.
        var blogoholic_pro_settings = ['blogoholic_pro_slider_num', 'blogoholic_pro_services_num', 'blogoholic_pro_projects_num', 'blogoholic_pro_testimonial_num', 'blogoholic_pro_blog_section_num', 'blogoholic_pro_reset_settings', 'blogoholic_pro_testimonial_num', 'blogoholic_pro_partner_num'];
        _.each( blogoholic_pro_settings, function( blogoholic_pro_setting ) {
            wp.customize( blogoholic_pro_setting, function( setting ) {
                var blogoholicNotice = function( value ) {
                    var name = 'needs_refresh';
                    if ( value && blogoholic_pro_setting == 'blogoholic_pro_reset_settings' ) {
                        setting.notifications.add( 'needs_refresh', new wp.customize.Notification(
                            name,
                            {
                                type: 'warning',
                                message: localized_data.reset_msg,
                            }
                        ) );
                    } else if( value ){
                        setting.notifications.add( 'reset_name', new wp.customize.Notification(
                            name,
                            {
                                type: 'info',
                                message: localized_data.refresh_msg,
                            }
                        ) );
                    } else {
                        setting.notifications.remove( name );
                    }
                };

                setting.bind( blogoholicNotice );
            });
        });

        /* === Radio Image Control === */
        api.controlConstructor['radio-color'] = api.Control.extend( {
            ready: function() {
                var control = this;

                $( 'input:radio', control.container ).change(
                    function() {
                        control.setting.set( $( this ).val() );
                    }
                );
            }
        } );

        // Sortable sections
        jQuery( "body" ).on( 'hover', '.blogoholic-drag-handle', function() {
            jQuery( 'ul.blogoholic-sortable-list' ).sortable({
                handle: '.blogoholic-drag-handle',
                axis: 'y',
                update: function( e, ui ){
                    jQuery('input.blogoholic-sortable-input').trigger( 'change' );
                }
            });
        });

        /* On changing the value. */
        jQuery( "body" ).on( 'change', 'input.blogoholic-sortable-input', function() {
            /* Get the value, and convert to string. */
            this_checkboxes_values = jQuery( this ).parents( 'ul.blogoholic-sortable-list' ).find( 'input.blogoholic-sortable-input' ).map( function() {
                return this.value;
            }).get().join( ',' );

            /* Add the value to hidden input. */
            jQuery( this ).parents( 'ul.blogoholic-sortable-list' ).find( 'input.blogoholic-sortable-value' ).val( this_checkboxes_values ).trigger( 'change' );

        });

        // Deep linking for counter section to about section.
        jQuery('.blogoholic-edit').click(function(e) {
            e.preventDefault();
            var jump_to = jQuery(this).attr( 'data-jump' );
            wp.customize.section( jump_to ).focus()
        });

    });
})( jQuery, wp.customize );
