<?php
/**
 * 
 *
 * @see blogoholic_pro_custom_header_setup().
 */
function blogoholic_pro_header_text_style() {
	// If we get this far, we have custom styles. Let's do this.
	$header_text_display = get_theme_mod( 'blogoholic_pro_header_text_display' );
	?>
	<style type="text/css">

	<?php if ( !empty( get_theme_mod( 'blogoholic_pro_h1_h6_font_option' ) ) ): ?>
		h1,
		h2,
		h3,
		h4,
		h5,
		h6,
		.btn,
		.site-title,
		.post-navigation a, 
		.section-title,
		.posts-navigation a,
		.single-post-wrapper span.tags-links,
		.single-post-wrapper span.cat-links,
		.blog-posts-wrapper .cat-links a,
		.blog-posts-wrapper .cat-links,
		.woocommerce div.product .woocommerce-tabs ul.tabs li a {
			font-family: <?php echo esc_attr(str_replace("+", " ", get_theme_mod('blogoholic_pro_h1_h6_font_option'))); ?>;
		}
	<?php endif; ?>	
			
	<?php if ( !empty( get_theme_mod( 'blogoholic_pro_body_font_option' ) ) ): ?>
			body,
			.cat-links a, .posted-on a,
			.main-navigation a,
			.post-categories a,
			.single-post-wrapper span.tags-links a,
			.single-post-wrapper span.cat-links a,
			.blog-posts-wrapper span.cat-links,
			.blog-posts-wrapper span.cat-links a,
			.blog-posts-wrapper span.cat-links,
			.blog-posts-wrapper span.cat-links a {
				font-family: <?php echo esc_attr(str_replace("+", " ", get_theme_mod('blogoholic_pro_body_font_option'))); ?>;
		}
	<?php endif; ?>	

	.site-title a{
		color: #<?php echo esc_attr( get_header_textcolor() ); ?>;
	}
	.site-description {
		color: <?php echo esc_attr( get_theme_mod( 'blogoholic_pro_header_tagline', '#2e2e2e' ) ); ?>;
	}

	<?php if ( get_theme_mod( 'blogoholic_pro_topbar_menu' ) == false ): ?>
		.main-navigation .social-menu-item:after {
		    display: none;
		}
	<?php endif ?>

	<?php if ( get_theme_mod( 'blogoholic_pro_topbar_search' ) == false ): ?>
		#top-navigation .icon-wrapper span a:after {
		    display: none;
		}
	<?php endif ?>



	/*header styles*/

	<?php if ( get_theme_mod( 'blogoholic_pro_header_style' ) == 'header-2' ): ?>
		.site-branding{
			width: <?php echo ( get_theme_mod( 'blogoholic_pro_header_display', 'ads' ) == 'none' ) ? '100%' : '40%'; ?>;
			<?php echo ( get_theme_mod( 'blogoholic_pro_header_display', 'ads' ) == 'none' ) ? "text-align:center" : ''; ?>;
		}
	
		#masthead nav {
			border-bottom: 5px solid #000;
			border-top: 2px solid #000;
			width: 100%;
		} 
		
		@media screen and (min-width: 1024px){
		.main-navigation ul.nav-menu{
				float: none;
			}
		}
		.header-2 svg.icon-facebook{
			
		}
	<?php endif ?>


	<?php if ( !is_active_sidebar( 'blog-sidebar' ) ) { ?>
		.second-design.home .archive-blog-wrapper article:nth-child(2n+1) {
		    clear: none;
		}
		.second-design.home .archive-blog-wrapper article {
    		width: 33.33%;
    	}	
	<?php } ?>	

	<?php if ( !empty(get_theme_mod( 'blogoholic_pro_header_media_video_code' ) ) ): ?>
		#page-site-header {
			padding: 0px;
		}

		#page-site-header iframe{
			top: 0px;
		    left: 0px;
		    right: 0px;
		    width: 100%;
		    max-height: 600px;
		    border: none;
		    height: -webkit-fill-available;
		}

		#page-site-header .wrapper{
			top:80%;
		}
		#page-site-header .page-title{
			position: relative;
		}
		#page-site-header #breadcrumb-list{
			position: relative;
		}
	<?php endif ?>	

	
	</style>

	<?php
}
add_action( 'wp_head', 'blogoholic_pro_header_text_style' );