<?php
/**
 * Moral Theme Customizer
 *
 * @package Moral
 *
 * banner section
 */

$wp_customize->add_section(
	'blogoholic_pro_banner',
	array(
		'title' => esc_html__( 'Banner', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_home_panel',
	)
);

// banner enable settings
$wp_customize->add_setting(
	'blogoholic_pro_banner',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'recent'
	)
);

$wp_customize->add_control(
	'blogoholic_pro_banner',
	array(
		'section'		=> 'blogoholic_pro_banner',
		'label'			=> esc_html__( 'Content type:', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'blogoholic-pro' ),
		'type'			=> 'select',
		'choices'		=> array( 
				'disable' => esc_html__( '--Disable--', 'blogoholic-pro' ),
				'post' => esc_html__( 'Post', 'blogoholic-pro' ),
				'page' => esc_html__( 'Page', 'blogoholic-pro' ),
				'cat' => esc_html__( 'Category', 'blogoholic-pro' ),
				'recent' => esc_html__( 'Recent', 'blogoholic-pro' ),
		 	)
	)
);

$banner_count = 5;
if ( get_theme_mod( 'blogoholic_pro_homepage_layout' ) == 'third-design' ) {
	$banner_count = 6;
}

for ($i=1; $i <= $banner_count ; $i++) { 
	// banner post setting
	$wp_customize->add_setting(
		'blogoholic_pro_banner_post_'.$i,
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'blogoholic_pro_banner_post_'.$i,
		array(
			'section'		=> 'blogoholic_pro_banner',
			'label'			=> esc_html__( 'Post ', 'blogoholic-pro' ).$i,
			'active_callback' => 'blogoholic_pro_if_banner_post',
			'type'			=> 'select',
			'choices'		=> blogoholic_pro_get_post_choices(),
		)
	);

	// banner page setting
	$wp_customize->add_setting(
		'blogoholic_pro_banner_page_'.$i,
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_dropdown_pages',
			'default' => 0,
		)
	);

	$wp_customize->add_control(
		'blogoholic_pro_banner_page_'.$i,
		array(
			'section'		=> 'blogoholic_pro_banner',
			'label'			=> esc_html__( 'Page ', 'blogoholic-pro' ).$i,
			'type'			=> 'dropdown-pages',
			'active_callback' => 'blogoholic_pro_if_banner_page'
		)
	);
}

// banner category setting
$wp_customize->add_setting(
	'blogoholic_pro_banner_cat',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_banner_cat',
	array(
		'section'		=> 'blogoholic_pro_banner',
		'label'			=> esc_html__( 'Category:', 'blogoholic-pro' ),
		'active_callback' => 'blogoholic_pro_if_banner_cat',
		'type'			=> 'select',
		'choices'		=> blogoholic_pro_get_post_cat_choices(),
	)
);
