<?php
/**
 * Moral Theme Customizer
 *
 * @package Moral
 *
 * blog section
 */
$wp_customize->add_section(
	'blogoholic_pro_blog',
	array(
		'title' => esc_html__( 'Blog Post', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_home_panel',
	)
);
// blog enable settings
$wp_customize->add_setting(
	'blogoholic_pro_blog',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'recent'
	)
);
$wp_customize->add_control(
	'blogoholic_pro_blog',
	array(
		'section'		=> 'blogoholic_pro_blog',
		'label'			=> esc_html__( 'Content type:', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'blogoholic-pro' ),
		'type'			=> 'select',
		'choices'		=> array(
				'disable' => esc_html__( '--Disable--', 'blogoholic-pro' ),
				'post' => esc_html__( 'Post', 'blogoholic-pro' ),
				'page' => esc_html__( 'Page', 'blogoholic-pro' ),
				'cat' => esc_html__( 'Category', 'blogoholic-pro' ),
				'recent' => esc_html__( 'Recent', 'blogoholic-pro' ),
		 	)
	)
);
$wp_customize->add_setting( 'blogoholic_pro_ads_image_1', array(
	'sanitize_callback' => 'blogoholic_pro_sanitize_image',
) );
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'blogoholic_pro_ads_image_1',
	array(
	'label'       		=> esc_html__( 'Ads Image 1', 'blogoholic-pro' ),
	'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'blogoholic-pro' ), 810, 120 ),
	'section'     		=> 'blogoholic_pro_blog',
	'active_callback'	=> 'blogoholic_pro_if_blog_enabled',
) ) );
$wp_customize->add_setting(
	'blogoholic_pro_ads_url_1',
	array(
		'sanitize_callback' => 'esc_url_raw',
	)
);
$wp_customize->add_control(
	'blogoholic_pro_ads_url_1',
	array(
		'section'		=> 'blogoholic_pro_blog',
		'label'			=> esc_html__( 'Ads Url 1:', 'blogoholic-pro' ),
		'active_callback' => 'blogoholic_pro_if_blog_enabled'
	)
);
$wp_customize->add_setting( 'blogoholic_pro_ads_image_2', array(
	'sanitize_callback' => 'blogoholic_pro_sanitize_image',
) );
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'blogoholic_pro_ads_image_2',
	array(
	'label'       		=> esc_html__( 'Ads Image 2', 'blogoholic-pro' ),
	'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'blogoholic-pro' ), 810, 120 ),
	'section'     		=> 'blogoholic_pro_blog',
	'active_callback'	=> 'blogoholic_pro_if_blog_enabled',
) ) );
$wp_customize->add_setting(
	'blogoholic_pro_ads_url_2',
	array(
		'sanitize_callback' => 'esc_url_raw',
	)
);
$wp_customize->add_control(
	'blogoholic_pro_ads_url_2',
	array(
		'section'		=> 'blogoholic_pro_blog',
		'label'			=> esc_html__( 'Ads Url 2', 'blogoholic-pro' ),
		'active_callback' => 'blogoholic_pro_if_blog_enabled'
	)
);
$wp_customize->add_setting(
	'blogoholic_pro_blog_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default' => esc_html__( 'More Articles', 'blogoholic-pro' ),
		'transport'	=> 'postMessage',
	)
);
$wp_customize->add_control(
	'blogoholic_pro_blog_title',
	array(
		'section'		=> 'blogoholic_pro_blog',
		'label'			=> esc_html__( 'Section Title:', 'blogoholic-pro' ),
		'active_callback' => 'blogoholic_pro_if_blog_enabled'
	)
);
$wp_customize->selective_refresh->add_partial(
	'blogoholic_pro_blog_title',
	array(
        'selector'            => '#inner-content-wrapper .section-title',
		'render_callback'     => 'blogoholic_pro_blog_partial_title',
	)
);
$wp_customize->add_setting(
	'blogoholic_pro_blog_btn_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default' => esc_html__( 'Load More', 'blogoholic-pro' ),
		'transport'	=> 'postMessage',
	)
);
$wp_customize->add_control(
	'blogoholic_pro_blog_btn_title',
	array(
		'section'		=> 'blogoholic_pro_blog',
		'label'			=> esc_html__( 'Btn Title:', 'blogoholic-pro' ),
		'active_callback' => 'blogoholic_pro_if_blog_enabled'
	)
);
$wp_customize->selective_refresh->add_partial(
	'blogoholic_pro_blog_btn_title',
	array(
        'selector'            => '#inner-content-wrapper .read-more a',
		'render_callback'     => 'blogoholic_pro_blog_partial_btn_title',
	)
);
$wp_customize->add_setting(
	'blogoholic_pro_blog_btn_url',
	array(
		'sanitize_callback' => 'esc_url_raw',
	)
);
$wp_customize->add_control(
	'blogoholic_pro_blog_btn_url',
	array(
		'section'		=> 'blogoholic_pro_blog',
		'label'			=> esc_html__( 'Btn Url:', 'blogoholic-pro' ),
		'type'			=> 'url',
		'active_callback' => 'blogoholic_pro_if_blog_enabled'
	)
);
// blog number setting
$wp_customize->add_setting(
	'blogoholic_pro_blog_num',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_number_range',
		'default' => 3,
		'transport'	=> 'postMessage',
	)
);
$wp_customize->add_control(
	'blogoholic_pro_blog_num',
	array(
		'section'		=> 'blogoholic_pro_blog',
		'label'			=> esc_html__( 'Number of posts:', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'Min: 3 | Max: 12', 'blogoholic-pro' ),
		'type'			=> 'number',
		'input_attrs'	=> array( 'min' => 3, 'max' => 12 ),
		'active_callback' => 'blogoholic_pro_if_blog_enabled'
	)
);
$blog_num = get_theme_mod( 'blogoholic_pro_blog_num', 3 );
for ($i=1; $i <= $blog_num ; $i++) {
	// blog post setting
	$wp_customize->add_setting(
		'blogoholic_pro_blog_post_'.$i,
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_dropdown_pages',
		)
	);
	$wp_customize->add_control(
		'blogoholic_pro_blog_post_'.$i,
		array(
			'section'		=> 'blogoholic_pro_blog',
			'label'			=> esc_html__( 'Post ', 'blogoholic-pro' ).$i,
			'active_callback' => 'blogoholic_pro_if_blog_post',
			'type'			=> 'select',
			'choices'		=> blogoholic_pro_get_post_choices(),
		)
	);
	// blog page setting
	$wp_customize->add_setting(
		'blogoholic_pro_blog_page_'.$i,
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_dropdown_pages',
			'default' => 0,
		)
	);
	$wp_customize->add_control(
		'blogoholic_pro_blog_page_'.$i,
		array(
			'section'		=> 'blogoholic_pro_blog',
			'label'			=> esc_html__( 'Page ', 'blogoholic-pro' ).$i,
			'type'			=> 'dropdown-pages',
			'active_callback' => 'blogoholic_pro_if_blog_page'
		)
	);
}
// blog category setting
$wp_customize->add_setting(
	'blogoholic_pro_blog_cat',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
	)
);
$wp_customize->add_control(
	'blogoholic_pro_blog_cat',
	array(
		'section'		=> 'blogoholic_pro_blog',
		'label'			=> esc_html__( 'Category:', 'blogoholic-pro' ),
		'active_callback' => 'blogoholic_pro_if_blog_cat',
		'type'			=> 'select',
		'choices'		=> blogoholic_pro_get_post_cat_choices(),
	)
);