<?php
/**
 * Moral Theme Customizer
 *
 * @package Moral
 *
 * breakingnews section
 */

$wp_customize->add_section(
	'blogoholic_pro_breakingnews',
	array(
		'title' => esc_html__( 'Breakingnews', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_home_panel',
	)
);

// breakingnews enable settings
$wp_customize->add_setting(
	'blogoholic_pro_breakingnews',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'recent'
	)
);

$wp_customize->add_control(
	'blogoholic_pro_breakingnews',
	array(
		'section'		=> 'blogoholic_pro_breakingnews',
		'label'			=> esc_html__( 'Content type:', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'blogoholic-pro' ),
		'type'			=> 'select',
		'choices'		=> array( 
				'disable' => esc_html__( '--Disable--', 'blogoholic-pro' ),
				'recent' => esc_html__( 'Recent', 'blogoholic-pro' ),
				'cat' => esc_html__( 'Category', 'blogoholic-pro' ),
		 	)
	)
);


// breakingnews category setting
$wp_customize->add_setting(
	'blogoholic_pro_breakingnews_cat',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_breakingnews_cat',
	array(
		'section'		=> 'blogoholic_pro_breakingnews',
		'label'			=> esc_html__( 'Category:', 'blogoholic-pro' ),
		'active_callback' => 'blogoholic_pro_if_breakingnews_cat',
		'type'			=> 'select',
		'choices'		=> blogoholic_pro_get_post_cat_choices(),
	)
);
