<?php
/**
 * Moral Theme Customizer
 *
 * @package Moral
 *
 * category section
 */

$wp_customize->add_section(
	'blogoholic_pro_category',
	array(
		'title' => esc_html__( 'Category Slider', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_home_panel',
	)
);

// category enable settings
$wp_customize->add_setting(
	'blogoholic_pro_category',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'disable'
	)
);

$wp_customize->add_control(
	'blogoholic_pro_category',
	array(
		'section'		=> 'blogoholic_pro_category',
		'label'			=> esc_html__( 'Content type:', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'blogoholic-pro' ),
		'type'			=> 'select',
		'choices'		=> array( 
				'disable' => esc_html__( '--Disable--', 'blogoholic-pro' ),
				'cat' => esc_html__( 'Category', 'blogoholic-pro' ),
		 	)
	)
);

for( $i = 1; $i < 4 ; $i++ ){
	// fashion category setting
	$wp_customize->add_setting(
		'blogoholic_pro_category_cat_'.$i,
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		)
	);

	$wp_customize->add_control(
		'blogoholic_pro_category_cat_'.$i,
		array(
			'section'		=> 'blogoholic_pro_category',
			'label'			=> esc_html__( 'Category ', 'blogoholic-pro' ).$i,

			'type'			=> 'select',
			'choices'		=> blogoholic_pro_get_post_cat_choices(),
			'active_callback'	=> 'blogoholic_pro_if_category_enabled',
		)
	);
}

