<?php
/**
 * Moral Theme Customizer
 *
 * @package Moral
 */

/**
 * Get all the default values of the theme mods.
 */
function blogoholic_pro_get_default_mods() {
	$blogoholic_pro_default_mods = array(
		// Footer copyright
		'blogoholic_pro_copyright_txt' => esc_html__( 'Copyright &copy; [the-year] [site-link]  |  ', 'blogoholic-pro' ),
		'blogoholic_pro_power_by_txt'	=> sprintf( esc_html__( 'Theme: %1$s by %2$s.', 'blogoholic-pro' ), 'blogoholic Pro', '<a href="' . esc_url( 'http://moralthemes.com/' ) . '">Moral Themes</a>' ),
	);

	return apply_filters( 'blogoholic_pro_default_mods', $blogoholic_pro_default_mods );
}

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function blogoholic_pro_customize_register( $wp_customize ) {

	// Custom Controller
	require get_parent_theme_file_path( '/inc/customizer/custom-controller.php' );

	$default = blogoholic_pro_get_default_mods();

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector'        => '.site-title a',
			'render_callback' => 'blogoholic_pro_customize_partial_blogname',
		) );
		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector'        => '.site-description',
			'render_callback' => 'blogoholic_pro_customize_partial_blogdescription',
		) );
	}

	//header text
	$wp_customize->add_setting(
	'blogoholic_pro_header_text',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default' => esc_html__( 'View Full Stories', 'blogoholic-pro' ),
		'transport'	=> 'postMessage',
	)
	);

	$wp_customize->add_control(
		'blogoholic_pro_header_text',
		array(
			'section'		=> 'header_image',
			'label'			=> esc_html__( 'Enable Banner In Hompage:', 'blogoholic-pro' ),
			'description'	=> esc_html__( 'Note: This setting is only work for Hompage.', 'blogoholic-pro' ),
			'type'			=> 'checkbox',
		)
	);

	$wp_customize->selective_refresh->add_partial( 
		'blogoholic_pro_header_text', 
		array(
	        'selector'            => '#about-us .read-more a',
			'render_callback'     => 'blogoholic_pro_about_partial_btn_title',
		) 
	);

	//Color Panel

	// Header tagline color setting
	$wp_customize->add_setting(	
		'blogoholic_pro_header_tagline',
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_hex_color',
			'default' => '#929292',
			'transport'	=> 'postMessage',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control( 
		$wp_customize,
			'blogoholic_pro_header_tagline',
			array(
				'section'		=> 'colors',
				'label'			=> esc_html__( 'Site tagline Color:', 'blogoholic-pro' ),
			)
		)
	);

	// Header tagline color setting
	$wp_customize->add_setting(	
		'blogoholic_pro_theme_color_scheme',
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_select',
			'default' => 'lite-version',
		)
	);

	$wp_customize->add_control( 'blogoholic_pro_theme_color_scheme',
		array(
			'section'		=> 'colors',
			'type'			=> 'radio',
			'label'			=> esc_html__( 'Theme color scheme:', 'blogoholic-pro' ),
			'choices'			=> array( 
				'lite-version' => esc_html__( 'Lite', 'blogoholic-pro' ), 
				'dark-version' => esc_html__( 'Dark', 'blogoholic-pro' ), 
			),
		)
	);

	// Color scheme setting
	$wp_customize->add_setting(	
		'blogoholic_pro_color_scheme',
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_select',
			'default'	=> 'default',
		)
	);

	$wp_customize->add_control( 
		new Blogoholic_Pro_Customize_Control_Radio_Color( 
		$wp_customize,
		'blogoholic_pro_color_scheme',
		array(
			'section'		=> 'colors',
			'type'			=> 'radio-color',
			'label'			=> esc_html__( 'Color scheme:', 'blogoholic-pro' ),
			'choices'		=> array( 
				'default' => array( 
					'color' => '#0563D8'
				),
				'red' => array( 
					'color' => '#fb3c3c'
				),
				'green' => array( 
					'color' => '#0cc652'
				),
				'yellow' => array( 
					'color' => '#f5d246'
				),
				'custom' => array( 
					'color' => '#0563D8'
				),
			),
		)
	)
	);

	// Custom color scheme scheme setting
	$wp_customize->add_setting(	
		'blogoholic_pro_custom_color_scheme',
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_hex_color',
			'default' => '#e83a3c',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control( 
		$wp_customize,
			'blogoholic_pro_custom_color_scheme',
			array(
				'section'		=> 'colors',
				'label'			=> esc_html__( 'Custom color:', 'blogoholic-pro' ),
				'active_callback' => 'blogoholic_pro_if_custom_color_scheme',
			)
		)
	);

	// Header text display setting
	$wp_customize->add_setting(	
		'blogoholic_pro_header_text_display',
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
			'default' => true,
			'transport'	=> 'postMessage',
		)
	);

	$wp_customize->add_control(
		'blogoholic_pro_header_text_display',
		array(
			'section'		=> 'title_tagline',
			'type'			=> 'checkbox',
			'label'			=> esc_html__( 'Display Site Title and Tagline', 'blogoholic-pro' ),
		)
	);

	// Your latest posts title setting
	$wp_customize->add_setting(	
		'blogoholic_pro_your_latest_posts_title',
		array(
			'sanitize_callback' => 'sanitize_text_field',
			'default' => esc_html__( 'Blogs', 'blogoholic-pro' ),
			'transport'	=> 'postMessage',
		)
	);

	$wp_customize->add_control(
		'blogoholic_pro_your_latest_posts_title',
		array(
			'section'		=> 'static_front_page',
			'label'			=> esc_html__( 'Title:', 'blogoholic-pro' ),
			'active_callback' => 'blogoholic_pro_is_latest_posts'
		)
	);

	$wp_customize->selective_refresh->add_partial( 
		'blogoholic_pro_your_latest_posts_title', 
		array(
	        'selector'            => '.home.blog #page-header .page-title',
			'render_callback'     => 'blogoholic_pro_your_latest_posts_partial_title',
    	) 
    );


    $wp_customize->add_setting( 'blogoholic_pro_header_media_seperator', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );


	/**
	 * 
	 * Front Section
	 * 
	 */ 

	// Home sections panel
	$wp_customize->add_panel(
		'blogoholic_pro_home_panel',
		array(
			'title' => esc_html__( 'Homepage Options', 'blogoholic-pro' ),
			'priority' => 105
		)
	);

	//home page
    require get_parent_theme_file_path( '/inc/customizer/homepage-layout.php' );

    //top-bar
    require get_parent_theme_file_path( '/inc/customizer/top-bar.php' );

    if ( get_theme_mod( 'blogoholic_pro_homepage_layout', 'first-design' ) == 'second-design' ) {
	    //breakingnews
	    require get_parent_theme_file_path( '/inc/customizer/breakingnews.php' );
    }

    //banner
    require get_parent_theme_file_path( '/inc/customizer/banner.php' );

    //slider
    require get_parent_theme_file_path( '/inc/customizer/slider.php' );

    //recent
    require get_parent_theme_file_path( '/inc/customizer/recent.php' );

    if ( get_theme_mod( 'blogoholic_pro_homepage_layout', 'first-design' ) !== 'second-design' ) {
	    //lifestyle
	    require get_parent_theme_file_path( '/inc/customizer/lifestyle.php' );
    }
    
    //fitness
    require get_parent_theme_file_path( '/inc/customizer/fitness.php' );

    //culture
    require get_parent_theme_file_path( '/inc/customizer/culture.php' );

    //fashion
    require get_parent_theme_file_path( '/inc/customizer/fashion.php' );

    if ( get_theme_mod( 'blogoholic_pro_homepage_layout', 'first-design' ) !== 'second-design' ) {
	    //subscribe
    	require get_parent_theme_file_path( '/inc/customizer/subscribe.php' );
    }    

    //category
    require get_parent_theme_file_path( '/inc/customizer/category.php' );


    if ( get_theme_mod( 'blogoholic_pro_homepage_layout', 'first-design' ) !== 'second-design' ) {
	    //featured
    	require get_parent_theme_file_path( '/inc/customizer/featured.php' );
    }   

    //blog
    require get_parent_theme_file_path( '/inc/customizer/blog.php' );

    //editor
    require get_parent_theme_file_path( '/inc/customizer/editor.php' );



	// Theme Options
	require get_parent_theme_file_path( '/inc/customizer/theme-option.php' );
}
add_action( 'customize_register', 'blogoholic_pro_customize_register' );


// Sanitize Callback
require get_parent_theme_file_path( '/inc/customizer/sanitize-callback.php' );

// active Callback
require get_parent_theme_file_path( '/inc/customizer/active-callback.php' );

// Partial Refresh
require get_parent_theme_file_path( '/inc/customizer/partial-refresh.php' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function blogoholic_pro_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function blogoholic_pro_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function blogoholic_pro_customize_preview_js() {
	wp_enqueue_script( 'blogoholic-customizer', get_theme_file_uri( '/assets/js/customizer.js' ), array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'blogoholic_pro_customize_preview_js' );

/**
 * Binds JS handlers for Customizer controls.
 */
function blogoholic_pro_customize_control_js() {


	wp_enqueue_style( 'blogoholic-customize-style', get_theme_file_uri( '/assets/css/customize-controls.css' ), array(), '20151215' );

	wp_enqueue_script( 'blogoholic-customize-control', get_theme_file_uri( '/assets/js/customize-control.js' ), array( 'jquery', 'customize-controls' ), '20151215', true );
	$localized_data = array( 
		'refresh_msg' => esc_html__( 'Refresh the page after Save and Publish.', 'blogoholic-pro' ),
		'reset_msg' => esc_html__( 'Warning!!! This will reset all the settings. Refresh the page after Save and Publish to reset all.', 'blogoholic-pro' ),
	);

	wp_localize_script( 'blogoholic-customize-control', 'localized_data', $localized_data );
}
add_action( 'customize_controls_enqueue_scripts', 'blogoholic_pro_customize_control_js' );
