<?php
/**
 * Moral Theme Customizer
 *
 * @package Moral
 *
 * editor section
 */

$wp_customize->add_section(
	'blogoholic_pro_editor',
	array(
		'title' => esc_html__( 'Editor Choice', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_home_panel',
	)
);

// editor enable settings
$wp_customize->add_setting(
	'blogoholic_pro_editor',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'recent'
	)
);

$wp_customize->add_control(
	'blogoholic_pro_editor',
	array(
		'section'		=> 'blogoholic_pro_editor',
		'label'			=> esc_html__( 'Content type:', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'blogoholic-pro' ),
		'type'			=> 'select',
		'choices'		=> array( 
				'disable' => esc_html__( '--Disable--', 'blogoholic-pro' ),
				'post' => esc_html__( 'Post', 'blogoholic-pro' ),
				'page' => esc_html__( 'Page', 'blogoholic-pro' ),
				'cat' => esc_html__( 'Category', 'blogoholic-pro' ),
				'recent' => esc_html__( 'Recent', 'blogoholic-pro' ),
		 	)
	)
);

$wp_customize->add_setting(
	'blogoholic_pro_editor_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default' => esc_html__( 'Editors Picks', 'blogoholic-pro' ),
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_editor_title',
	array(
		'section'		=> 'blogoholic_pro_editor',
		'label'			=> esc_html__( 'Section Title:', 'blogoholic-pro' ),
		'active_callback' => 'blogoholic_pro_if_editor_enabled'
	)
);

$wp_customize->selective_refresh->add_partial( 
	'blogoholic_pro_editor_title', 
	array(
        'selector'            => '#editor-slider .section-btn_title',
		'render_callback'     => 'blogoholic_pro_editor_partial_title',
	) 
);

// editor number setting
$wp_customize->add_setting(
	'blogoholic_pro_editor_num',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_number_range',
		'default' => 4,
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_editor_num',
	array(
		'section'		=> 'blogoholic_pro_editor',
		'label'			=> esc_html__( 'Number of post:', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'Min: 4 | Max: 12', 'blogoholic-pro' ),
		'type'			=> 'number',
		'input_attrs'	=> array( 'min' => 4, 'max' => 12 ),
		'active_callback' => 'blogoholic_pro_if_editor_enabled'
	)
);

$editor_num = get_theme_mod( 'blogoholic_pro_editor_num', 4 );
for ($i=1; $i <= $editor_num ; $i++) { 
	// blog post setting
	$wp_customize->add_setting(
		'blogoholic_pro_editor_post_'.$i,
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'blogoholic_pro_editor_post_'.$i,
		array(
			'section'		=> 'blogoholic_pro_editor',
			'label'			=> esc_html__( 'Post ', 'blogoholic-pro' ).$i,
			'active_callback' => 'blogoholic_pro_if_editor_post',
			'type'			=> 'select',
			'choices'		=> blogoholic_pro_get_post_choices(),
		)
	);

	// editor page setting
	$wp_customize->add_setting(
		'blogoholic_pro_editor_page_'.$i,
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_dropdown_pages',
			'default' => 0,
		)
	);

	$wp_customize->add_control(
		'blogoholic_pro_editor_page_'.$i,
		array(
			'section'		=> 'blogoholic_pro_editor',
			'label'			=> esc_html__( 'Page ', 'blogoholic-pro' ).$i,
			'type'			=> 'dropdown-pages',
			'active_callback' => 'blogoholic_pro_if_editor_page'
		)
	);
}

// editor category setting
$wp_customize->add_setting(
	'blogoholic_pro_editor_cat',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_editor_cat',
	array(
		'section'		=> 'blogoholic_pro_editor',
		'label'			=> esc_html__( 'Category:', 'blogoholic-pro' ),
		'active_callback' => 'blogoholic_pro_if_editor_cat',
		'type'			=> 'select',
		'choices'		=> blogoholic_pro_get_post_cat_choices(),
	)
);
