<?php
/**
 * Moral Theme Customizer
 *
 * @package Moral
 *
 * fashion section
 */

$wp_customize->add_section(
	'blogoholic_pro_fashion',
	array(
		'title' => esc_html__( 'Fashion & Design', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_home_panel',
	)
);

// fashion enable settings
$wp_customize->add_setting(
	'blogoholic_pro_fashion',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'recent'
	)
);

$wp_customize->add_control(
	'blogoholic_pro_fashion',
	array(
		'section'		=> 'blogoholic_pro_fashion',
		'label'			=> esc_html__( 'Content type:', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'blogoholic-pro' ),
		'type'			=> 'select',
		'choices'		=> array( 
				'disable' => esc_html__( '--Disable--', 'blogoholic-pro' ),
				'post' => esc_html__( 'Post', 'blogoholic-pro' ),
				'page' => esc_html__( 'Page', 'blogoholic-pro' ),
				'cat' => esc_html__( 'Category', 'blogoholic-pro' ),
				'recent' => esc_html__( 'Recent', 'blogoholic-pro' ),
		 	)
	)
);
$wp_customize->add_setting(
	'blogoholic_pro_fashion_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default' => esc_html__( 'Fashion & Design', 'blogoholic-pro' ),
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_fashion_title',
	array(
		'section'		=> 'blogoholic_pro_fashion',
		'label'			=> esc_html__( 'Title:', 'blogoholic-pro' ),
		'active_callback'	=> 'blogoholic_pro_if_fashion_enabled',
	)
);

$wp_customize->selective_refresh->add_partial( 
	'blogoholic_pro_fashion_title', 
	array(
        'selector'            => '#fashion .section-title',
		'render_callback'     => 'blogoholic_pro_fashion_partial_title',
	) 
);



// fashion number setting
$wp_customize->add_setting(
	'blogoholic_pro_fashion_num',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_number_range',
		'default' => 6,
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_fashion_num',
	array(
		'section'		=> 'blogoholic_pro_fashion',
		'label'			=> esc_html__( 'Number of posts:', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'Min: 6 | Max: 12', 'blogoholic-pro' ),
		'type'			=> 'number',
		'input_attrs'	=> array( 'min' => 6, 'max' => 12 ),
		'active_callback'	=> 'blogoholic_pro_if_fashion_enabled',
	)
);
$fashion_num = get_theme_mod( 'blogoholic_pro_fashion_num', 6 );
for ($i=1; $i <= $fashion_num ; $i++) { 
	// fashion post setting
	$wp_customize->add_setting(
		'blogoholic_pro_fashion_post_'.$i,
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'blogoholic_pro_fashion_post_'.$i,
		array(
			'section'		=> 'blogoholic_pro_fashion',
			'label'			=> esc_html__( 'Post ', 'blogoholic-pro' ).$i,
			'active_callback' => 'blogoholic_pro_if_fashion_post',
			'type'			=> 'select',
			'choices'		=> blogoholic_pro_get_post_choices(),
		)
	);

	// fashion page setting
	$wp_customize->add_setting(
		'blogoholic_pro_fashion_page_'.$i,
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_dropdown_pages',
			'default' => 0,
		)
	);

	$wp_customize->add_control(
		'blogoholic_pro_fashion_page_'.$i,
		array(
			'section'		=> 'blogoholic_pro_fashion',
			'label'			=> esc_html__( 'Page ', 'blogoholic-pro' ).$i,
			'type'			=> 'dropdown-pages',
			'active_callback' => 'blogoholic_pro_if_fashion_page'
		)
	);
}

// fashion category setting
$wp_customize->add_setting(
	'blogoholic_pro_fashion_cat',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_fashion_cat',
	array(
		'section'		=> 'blogoholic_pro_fashion',
		'label'			=> esc_html__( 'Category:', 'blogoholic-pro' ),
		'active_callback' => 'blogoholic_pro_if_fashion_cat',
		'type'			=> 'select',
		'choices'		=> blogoholic_pro_get_post_cat_choices(),
	)
);

