<?php
/**
 * Moral Theme Customizer
 *
 * @package Moral
 *
 * Featured section
 */
$wp_customize->add_section(
	'blogoholic_pro_featured',
	array(
		'title' => esc_html__( 'Featured Post', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_home_panel',
	)
);

// featured enable settings
$wp_customize->add_setting(
	'blogoholic_pro_featured',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'recent'
	)
);

$wp_customize->add_control(
	'blogoholic_pro_featured',
	array(
		'section'		=> 'blogoholic_pro_featured',
		'label'			=> esc_html__( 'Content type:', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'blogoholic-pro' ),
		'type'			=> 'select',
		'choices'		=> array( 
				'disable' => esc_html__( '--Disable--', 'blogoholic-pro' ),
				'post' => esc_html__( 'Post', 'blogoholic-pro' ),
				'page' => esc_html__( 'Page', 'blogoholic-pro' ),
				'recent' => esc_html__( 'Recent', 'blogoholic-pro' ),
		 	)
	)
);
$wp_customize->add_setting(
	'blogoholic_pro_featured_btn_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default' => esc_html__( 'Read More', 'blogoholic-pro' ),
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_featured_btn_title',
	array(
		'section'		=> 'blogoholic_pro_featured',
		'label'			=> esc_html__( 'Btn Title:', 'blogoholic-pro' ),
		'active_callback'	=> 'blogoholic_pro_if_featured_page',
	)
);

$wp_customize->selective_refresh->add_partial( 
	'blogoholic_pro_featured_btn_title', 
	array(
        'selector'            => '#featured .section-btn_title',
		'render_callback'     => 'blogoholic_pro_fashion_partial_btn_title',
	) 
);

$wp_customize->add_setting(
	'blogoholic_pro_featured_post',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_dropdown_pages',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_featured_post',
	array(
		'section'		=> 'blogoholic_pro_featured',
		'label'			=> esc_html__( 'Post ', 'blogoholic-pro' ),
		'active_callback' => 'blogoholic_pro_if_featured_post',
		'type'			=> 'select',
		'choices'		=> blogoholic_pro_get_post_choices(),
		'active_callback'	=> 'blogoholic_pro_if_featured_post',
	)
);

// featured page setting
$wp_customize->add_setting(
	'blogoholic_pro_featured_page',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_dropdown_pages',
		'default' => 0,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_featured_page',
	array(
		'section'		=> 'blogoholic_pro_featured',
		'label'			=> esc_html__( 'Page ', 'blogoholic-pro' ),
		'type'			=> 'dropdown-pages',
		'active_callback' => 'blogoholic_pro_if_featured_page'
	)
);
