<?php
/**
 * Moral Theme Customizer
 *
 * @package Moral
 *
 * fitness section
 */

$wp_customize->add_section(
	'blogoholic_pro_fitness',
	array(
		'title' => esc_html__( 'Fitness & Health', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_home_panel',
	)
);

// fitness enable settings
$wp_customize->add_setting(
	'blogoholic_pro_fitness',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'recent'
	)
);

$wp_customize->add_control(
	'blogoholic_pro_fitness',
	array(
		'section'		=> 'blogoholic_pro_fitness',
		'label'			=> esc_html__( 'Content type:', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'blogoholic-pro' ),
		'type'			=> 'select',
		'choices'		=> array( 
				'disable' => esc_html__( '--Disable--', 'blogoholic-pro' ),
				'post' => esc_html__( 'Post', 'blogoholic-pro' ),
				'page' => esc_html__( 'Page', 'blogoholic-pro' ),
				'cat' => esc_html__( 'Category', 'blogoholic-pro' ),
				'recent' => esc_html__( 'Recent', 'blogoholic-pro' ),
		 	)
	)
);
$wp_customize->add_setting(
	'blogoholic_pro_fitness_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default' => esc_html__( 'Fitness & Health', 'blogoholic-pro' ),
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_fitness_title',
	array(
		'section'		=> 'blogoholic_pro_fitness',
		'label'			=> esc_html__( 'Title:', 'blogoholic-pro' ),
		'active_callback'	=> 'blogoholic_pro_if_fitness_enabled',
	)
);

$wp_customize->selective_refresh->add_partial( 
	'blogoholic_pro_fitness_title', 
	array(
        'selector'            => '#fitness .section-title',
		'render_callback'     => 'blogoholic_pro_fitness_partial_title',
	) 
);


// fitness number setting
$wp_customize->add_setting(
	'blogoholic_pro_fitness_num',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_number_range',
		'default' => 3,
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_fitness_num',
	array(
		'section'		=> 'blogoholic_pro_fitness',
		'label'			=> esc_html__( 'Number of posts:', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'Min: 3 | Max: 12', 'blogoholic-pro' ),
		'type'			=> 'number',
		'input_attrs'	=> array( 'min' => 3, 'max' => 12 ),
		'active_callback'	=> 'blogoholic_pro_if_fitness_enabled',
	)
);
$fitness_num = get_theme_mod( 'blogoholic_pro_fitness_num', 3 );
for ($i=1; $i <= $fitness_num ; $i++) { 
	// fitness post setting
	$wp_customize->add_setting(
		'blogoholic_pro_fitness_post_'.$i,
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'blogoholic_pro_fitness_post_'.$i,
		array(
			'section'		=> 'blogoholic_pro_fitness',
			'label'			=> esc_html__( 'Post ', 'blogoholic-pro' ).$i,
			'active_callback' => 'blogoholic_pro_if_fitness_post',
			'type'			=> 'select',
			'choices'		=> blogoholic_pro_get_post_choices(),
		)
	);

	// fitness page setting
	$wp_customize->add_setting(
		'blogoholic_pro_fitness_page_'.$i,
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_dropdown_pages',
			'default' => 0,
		)
	);

	$wp_customize->add_control(
		'blogoholic_pro_fitness_page_'.$i,
		array(
			'section'		=> 'blogoholic_pro_fitness',
			'label'			=> esc_html__( 'Page ', 'blogoholic-pro' ).$i,
			'type'			=> 'dropdown-pages',
			'active_callback' => 'blogoholic_pro_if_fitness_page'
		)
	);
}

// fitness category setting
$wp_customize->add_setting(
	'blogoholic_pro_fitness_cat',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_fitness_cat',
	array(
		'section'		=> 'blogoholic_pro_fitness',
		'label'			=> esc_html__( 'Category:', 'blogoholic-pro' ),
		'active_callback' => 'blogoholic_pro_if_fitness_cat',
		'type'			=> 'select',
		'choices'		=> blogoholic_pro_get_post_cat_choices(),
	)
);