<?php
/**
 * Moral Theme Customizer
 *
 * @package Moral
 *
 * Header panel
 */

$wp_customize->add_panel(
	'blogoholic_pro_header_panel',
	array(
		'title' => esc_html__( 'Header', 'blogoholic-pro' ),
		'priority' => 100
	)
);



// Header section
$wp_customize->add_section(
	'blogoholic_pro_header_section',
	array(
		'title' => esc_html__( 'Header', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_header_panel',
	)
);

// Header menu sticky enable settings
$wp_customize->add_setting(
	'blogoholic_pro_make_menu_sticky',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => false
	)
);

$wp_customize->add_control(
	'blogoholic_pro_make_menu_sticky',
	array(
		'section'		=> 'blogoholic_pro_header_section',
		'label'			=> esc_html__( 'Make menu sticky.', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);

// Header menu sticky enable settings
$wp_customize->add_setting(
	'blogoholic_pro_header_style',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'header-1'
	)
);

$wp_customize->add_control(
	'blogoholic_pro_header_style',
	array(
		'section'		=> 'blogoholic_pro_header_section',
		'label'			=> esc_html__( 'Select Header Style', 'blogoholic-pro' ),
		'type'			=> 'select',
		'choices'		=> array( 
				'header-1' => esc_html__( 'Header 1', 'blogoholic-pro' ),
				'header-2' => esc_html__( 'Header 2', 'blogoholic-pro' ),
				'header-3' => esc_html__( 'Header 3', 'blogoholic-pro' ),
		 	)
	)
);


$wp_customize->add_setting(
	'blogoholic_pro_header_display',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'ads',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_header_display',
	array(
		'section'		=> 'blogoholic_pro_header_section',
		'label'			=> esc_html__( 'Header Display Option', 'blogoholic-pro' ),
		'type'			=> 'select',
		'active_callback'	=> 'blogoholic_pro_if_header_style',
		'choices'		=> array( 
				'social-menu' => esc_html__( 'Social Menu', 'blogoholic-pro' ),
				'none' => esc_html__( 'Nothing', 'blogoholic-pro' ),
				'ads' => esc_html__( 'Add Banner Image', 'blogoholic-pro' ),
		 	)
	)
);

$wp_customize->add_setting(
	'blogoholic_pro_nav_search',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => true
	)
);

$wp_customize->add_control(
	'blogoholic_pro_nav_search',
	array(
		'section'		=> 'blogoholic_pro_header_section',
		'label'			=> esc_html__( 'Enable Search Form', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
		'active_callback'	=> 'blogoholic_pro_if_header_nav_search',
	)
);

// ads image setting and control.
$wp_customize->add_setting( 'blogoholic_pro_header_ads_image', array(
	'sanitize_callback' => 'blogoholic_pro_sanitize_image',
	'default'			=> get_template_directory_uri() . '/assets/img/site-advertisement.jpg',
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'blogoholic_pro_header_ads_image',
	array(
	'label'       		=> esc_html__( 'Ads Image', 'blogoholic-pro' ),
	'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'blogoholic-pro' ), 810, 120 ),
	'section'     		=> 'blogoholic_pro_header_section',
	'active_callback'	=> 'blogoholic_pro_if_header_ads',
) ) );

// ads link setting and control
$wp_customize->add_setting( 'blogoholic_pro_header_ads_image_url', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'blogoholic_pro_header_ads_image_url', array(
	'label'           	=> esc_html__( 'Ads Url', 'blogoholic-pro' ),
	'section'        	=> 'blogoholic_pro_header_section',
	'type'				=> 'url',
	'active_callback'	=> 'blogoholic_pro_if_header_ads',
) );
