<?php
/**
 * Moral Theme Customizer
 *
 * @package Moral
 *
 * lifestyle section
 */

$wp_customize->add_section(
	'blogoholic_pro_lifestyle',
	array(
		'title' => esc_html__( 'Lifestyle', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_home_panel',
	)
);

// lifestyle enable settings
$wp_customize->add_setting(
	'blogoholic_pro_lifestyle',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'recent'
	)
);

$wp_customize->add_control(
	'blogoholic_pro_lifestyle',
	array(
		'section'		=> 'blogoholic_pro_lifestyle',
		'label'			=> esc_html__( 'Content type:', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'blogoholic-pro' ),
		'type'			=> 'select',
		'choices'		=> array( 
				'disable' => esc_html__( '--Disable--', 'blogoholic-pro' ),
				'post' => esc_html__( 'Post', 'blogoholic-pro' ),
				'page' => esc_html__( 'Page', 'blogoholic-pro' ),
				'cat' => esc_html__( 'Category', 'blogoholic-pro' ),
				'recent' => esc_html__( 'Recent', 'blogoholic-pro' ),
		 	)
	)
);
$wp_customize->add_setting(
	'blogoholic_pro_lifestyle_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default' => esc_html__( 'lifestyle Posts', 'blogoholic-pro' ),
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_lifestyle_title',
	array(
		'section'		=> 'blogoholic_pro_lifestyle',
		'label'			=> esc_html__( 'Title:', 'blogoholic-pro' ),
		'active_callback'	=> 'blogoholic_pro_if_lifestyle_enabled',
	)
);

$wp_customize->selective_refresh->add_partial( 
	'blogoholic_pro_lifestyle_title', 
	array(
        'selector'            => '#lifestyle .section-title',
		'render_callback'     => 'blogoholic_pro_lifestyle_partial_title',
	) 
);


// lifestyle number setting
$wp_customize->add_setting(
	'blogoholic_pro_lifestyle_num',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_number_range',
		'default' => 3,
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_lifestyle_num',
	array(
		'section'		=> 'blogoholic_pro_lifestyle',
		'label'			=> esc_html__( 'Number of posts:', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'Min: 3 | Max: 9', 'blogoholic-pro' ),
		'type'			=> 'number',
		'input_attrs'	=> array( 'min' => 3, 'max' => 9 ),
		'active_callback'	=> 'blogoholic_pro_if_lifestyle_enabled',
	)
);
$lifestyle_num = get_theme_mod( 'blogoholic_pro_lifestyle_num', 3 );
for ($i=1; $i <= $lifestyle_num ; $i++) { 
	// lifestyle post setting
	$wp_customize->add_setting(
		'blogoholic_pro_lifestyle_post_'.$i,
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'blogoholic_pro_lifestyle_post_'.$i,
		array(
			'section'		=> 'blogoholic_pro_lifestyle',
			'label'			=> esc_html__( 'Post ', 'blogoholic-pro' ).$i,
			'active_callback' => 'blogoholic_pro_if_lifestyle_post',
			'type'			=> 'select',
			'choices'		=> blogoholic_pro_get_post_choices(),
		)
	);

	// lifestyle page setting
	$wp_customize->add_setting(
		'blogoholic_pro_lifestyle_page_'.$i,
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_dropdown_pages',
			'default' => 0,
		)
	);

	$wp_customize->add_control(
		'blogoholic_pro_lifestyle_page_'.$i,
		array(
			'section'		=> 'blogoholic_pro_lifestyle',
			'label'			=> esc_html__( 'Page ', 'blogoholic-pro' ).$i,
			'type'			=> 'dropdown-pages',
			'active_callback' => 'blogoholic_pro_if_lifestyle_page'
		)
	);
}

// lifestyle category setting
$wp_customize->add_setting(
	'blogoholic_pro_lifestyle_cat',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_lifestyle_cat',
	array(
		'section'		=> 'blogoholic_pro_lifestyle',
		'label'			=> esc_html__( 'Category:', 'blogoholic-pro' ),
		'active_callback' => 'blogoholic_pro_if_lifestyle_cat',
		'type'			=> 'select',
		'choices'		=> blogoholic_pro_get_post_cat_choices(),
	)
);