<?php
/**
 * Moral Theme Customizer
 *
 * @package Moral
 *
 * Posts Slider section
 */

$wp_customize->add_section(
	'blogoholic_pro_post_slider',
	array(
		'title' => esc_html__( 'Slider', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_home_panel',
	)
);

// post_slider enable settings
$wp_customize->add_setting(
	'blogoholic_pro_post_slider',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'recentsmooth_blog_pro_if_header_style'
	)
);

$wp_customize->add_control(
	'blogoholic_pro_post_slider',
	array(
		'section'		=> 'blogoholic_pro_post_slider',
		'label'			=> esc_html__( 'Content type:', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'blogoholic-pro' ),
		'type'			=> 'select',
		'choices'		=> array( 
				'disable' => esc_html__( '--Disable--', 'blogoholic-pro' ),
				'post' => esc_html__( 'Post', 'blogoholic-pro' ),
				'page' => esc_html__( 'Page', 'blogoholic-pro' ),
				'cat' => esc_html__( 'Category', 'blogoholic-pro' ),
				'recent' => esc_html__( 'Recent', 'blogoholic-pro' ),
		 	)
	)
);

// post_slider number setting
$wp_customize->add_setting(
	'blogoholic_pro_post_slider_num',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_number_range',
		'default' => 5,
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_post_slider_num',
	array(
		'section'		=> 'blogoholic_pro_post_slider',
		'label'			=> esc_html__( 'Number of posts:', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'Min: 3 | Max: 12', 'blogoholic-pro' ),
		'type'			=> 'number',
		'input_attrs'	=> array( 'min' => 5, 'max' => 12 ),
		'active_callback'	=> 'blogoholic_pro_if_post_slider_enabled',
	)
);
$post_slider_num = get_theme_mod( 'blogoholic_pro_post_slider_num', 5 );
for ($i=1; $i <= $post_slider_num ; $i++) { 
	// post_slider post setting
	$wp_customize->add_setting(
		'blogoholic_pro_post_slider_post_'.$i,
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'blogoholic_pro_post_slider_post_'.$i,
		array(
			'section'		=> 'blogoholic_pro_post_slider',
			'label'			=> esc_html__( 'Post ', 'blogoholic-pro' ).$i,
			'active_callback' => 'blogoholic_pro_if_post_slider_post',
			'type'			=> 'select',
			'choices'		=> blogoholic_pro_get_post_choices(),
		)
	);

	// post_slider page setting
	$wp_customize->add_setting(
		'blogoholic_pro_post_slider_page_'.$i,
		array(
			'sanitize_callback' => 'blogoholic_pro_sanitize_dropdown_pages',
			'default' => 0,
		)
	);

	$wp_customize->add_control(
		'blogoholic_pro_post_slider_page_'.$i,
		array(
			'section'		=> 'blogoholic_pro_post_slider',
			'label'			=> esc_html__( 'Page ', 'blogoholic-pro' ).$i,
			'type'			=> 'dropdown-pages',
			'active_callback' => 'blogoholic_pro_if_post_slider_page'
		)
	);
}

// post_slider category setting
$wp_customize->add_setting(
	'blogoholic_pro_post_slider_cat',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_post_slider_cat',
	array(
		'section'		=> 'blogoholic_pro_post_slider',
		'label'			=> esc_html__( 'Category:', 'blogoholic-pro' ),
		'active_callback' => 'blogoholic_pro_if_post_slider_cat',
		'type'			=> 'select',
		'choices'		=> blogoholic_pro_get_post_cat_choices(),
	)
);