<?php
/**
 * Moral Theme Customizer
 *
 * @package Moral
 *
 * Subscribe section
 */
$wp_customize->add_section(
	'blogoholic_pro_suscribe',
	array(
		'title' => esc_html__( 'Subscribe', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_home_panel',
	)
);

// suscribe enable settings
$wp_customize->add_setting(
	'blogoholic_pro_suscribe',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'disable'
	)
);

$wp_customize->add_control(
	'blogoholic_pro_suscribe',
	array(
		'section'		=> 'blogoholic_pro_suscribe',
		'label'			=> esc_html__( 'Content type:', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'Choose where you want to render the content from.', 'blogoholic-pro' ),
		'type'			=> 'select',
		'choices'		=> array( 
				'disable' => esc_html__( '--Disable--', 'blogoholic-pro' ),
				'active' => esc_html__( 'Active', 'blogoholic-pro' ),
		 	)
	)
);
$wp_customize->add_setting(
	'blogoholic_pro_suscribe_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default' => esc_html__( 'Subscribe to Newsletter', 'blogoholic-pro' ),
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_suscribe_title',
	array(
		'section'		=> 'blogoholic_pro_suscribe',
		'label'			=> esc_html__( 'Title:', 'blogoholic-pro' ),
		'active_callback'	=> 'blogoholic_pro_if_suscribe_active',
	)
);

$wp_customize->selective_refresh->add_partial( 
	'blogoholic_pro_suscribe_title', 
	array(
        'selector'            => '#subscribe-now .section-title',
		'render_callback'     => 'blogoholic_pro_subscribe_partial_title',
	) 
);

$wp_customize->add_setting(
	'blogoholic_pro_suscribe_sub_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default' => esc_html__( 'Subscribe to stay up to date and stay notified about exclusive', 'blogoholic-pro' ),
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_suscribe_sub_title',
	array(
		'section'		=> 'blogoholic_pro_suscribe',
		'label'			=> esc_html__( 'Sub Title:', 'blogoholic-pro' ),
		'active_callback'	=> 'blogoholic_pro_if_suscribe_active',
	)
);

$wp_customize->selective_refresh->add_partial( 
	'blogoholic_pro_suscribe_sub_title', 
	array(
        'selector'            => '#subscribe-now .section-header p',
		'render_callback'     => 'blogoholic_pro_subscribe_partial_sub_title',
	) 
);

$wp_customize->add_setting(
	'blogoholic_pro_suscribe_btn_title',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default' => esc_html__( 'Subscribe', 'blogoholic-pro' ),
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_suscribe_btn_title',
	array(
		'section'		=> 'blogoholic_pro_suscribe',
		'label'			=> esc_html__( 'Btn Title:', 'blogoholic-pro' ),
		'active_callback'	=> 'blogoholic_pro_if_suscribe_active',
	)
);

$wp_customize->add_setting( 'blogoholic_pro_suscribe_image', array(
	'sanitize_callback' => 'blogoholic_pro_sanitize_image',
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'blogoholic_pro_suscribe_image',
		array(
		'label'       		=> esc_html__( 'Background Image', 'blogoholic-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'blogoholic-pro' ), 1280, 854 ),
		'section'     		=> 'blogoholic_pro_suscribe',
		'active_callback'	=> 'blogoholic_pro_if_suscribe_active',
) ) );