<?php
/**
 * Moral Theme Customizer
 *
 * @package Moral
 *
 * advance setting
 */

$wp_customize->add_panel(
	'blogoholic_pro_general_panel',
	array(
		'title' => esc_html__( 'Theme Options', 'blogoholic-pro' ),
		'priority' => 107
	)
);



//top-bar
require get_parent_theme_file_path( '/inc/customizer/top-bar.php' );


// Header section
$wp_customize->add_section(
	'blogoholic_pro_header_section',
	array(
		'title' => esc_html__( 'Header', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_general_panel',
	)
);

// Header menu sticky enable settings
$wp_customize->add_setting(
	'blogoholic_pro_make_menu_sticky',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => false
	)
);

$wp_customize->add_control(
	'blogoholic_pro_make_menu_sticky',
	array(
		'section'		=> 'blogoholic_pro_header_section',
		'label'			=> esc_html__( 'Make menu sticky.', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);

// Header menu sticky enable settings
$wp_customize->add_setting(
	'blogoholic_pro_header_style',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'header-1'
	)
);

$wp_customize->add_control(
	'blogoholic_pro_header_style',
	array(
		'section'		=> 'blogoholic_pro_header_section',
		'label'			=> esc_html__( 'Select Header Style', 'blogoholic-pro' ),
		'type'			=> 'select',
		'choices'		=> array( 
				'header-1' => esc_html__( 'Header 1', 'blogoholic-pro' ),
				'header-2' => esc_html__( 'Header 2', 'blogoholic-pro' ),
		 	)
	)
);


$wp_customize->add_setting(
	'blogoholic_pro_header_display',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'ads',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_header_display',
	array(
		'section'		=> 'blogoholic_pro_header_section',
		'label'			=> esc_html__( 'Header Display Option', 'blogoholic-pro' ),
		'type'			=> 'select',
		'active_callback'	=> 'blogoholic_pro_if_header_style',
		'choices'		=> array( 
				'social-menu' => esc_html__( 'Social Menu', 'blogoholic-pro' ),
				'none' => esc_html__( 'Nothing', 'blogoholic-pro' ),
				'ads' => esc_html__( 'Add Banner Image', 'blogoholic-pro' ),
		 	)
	)
);

// ads image setting and control.
$wp_customize->add_setting( 'blogoholic_pro_header_ads_image', array(
	'sanitize_callback' => 'blogoholic_pro_sanitize_image',
	'default'			=> get_template_directory_uri() . '/assets/img/site-advertisement.jpg',
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'blogoholic_pro_header_ads_image',
	array(
	'label'       		=> esc_html__( 'Ads Image', 'blogoholic-pro' ),
	'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'blogoholic-pro' ), 810, 120 ),
	'section'     		=> 'blogoholic_pro_header_section',
	'active_callback'	=> 'blogoholic_pro_if_header_ads',
) ) );

// ads link setting and control
$wp_customize->add_setting( 'blogoholic_pro_header_ads_image_url', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'blogoholic_pro_header_ads_image_url', array(
	'label'           	=> esc_html__( 'Ads Url', 'blogoholic-pro' ),
	'section'        	=> 'blogoholic_pro_header_section',
	'type'				=> 'url',
	'active_callback'	=> 'blogoholic_pro_if_header_ads',
) );

/**
 * Font section
 */
// Font section
$wp_customize->add_section(
	'blogoholic_pro_font',
	array(
		'title' => esc_html__( 'Font options', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_general_panel',
	)
);

// Font enable setting
$wp_customize->add_setting(
	'blogoholic_pro_h1_h6_font_option',
	array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'blogoholic_pro_h1_h6_font_option',
	array(
		'section'		=> 'blogoholic_pro_font',
		'label'			=> sprintf( esc_html__( 'H1 to H6 font family:', 'blogoholic-pro' ) ),
		'type'			=> 'select',
		'choices'		=> blogoholic_pro_font_choices(),
	)
);

// Body font setting
$wp_customize->add_setting(
	'blogoholic_pro_body_font_option',
	array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'blogoholic_pro_body_font_option',
	array(
		'section'		=> 'blogoholic_pro_font',
		'label'			=> esc_html__( 'Body font family:', 'blogoholic-pro' ),
		'type'			=> 'select',
		'choices'		=> blogoholic_pro_font_choices(),
	)
);


/**
 * General settings
 */
// General settings
$wp_customize->add_section(
	'blogoholic_pro_general_section',
	array(
		'title' => esc_html__( 'General', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_general_panel',
	)
);

// Breadcrumb enable setting
$wp_customize->add_setting(
	'blogoholic_pro_breadcrumb_enable',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => true,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_breadcrumb_enable',
	array(
		'section'		=> 'blogoholic_pro_general_section',
		'label'			=> esc_html__( 'Enable breadcrumb.', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);

// Backtop enable setting
$wp_customize->add_setting(
	'blogoholic_pro_back_to_top_enable',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => true,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_back_to_top_enable',
	array(
		'section'		=> 'blogoholic_pro_general_section',
		'label'			=> esc_html__( 'Enable Scroll up.', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);

/**
 * Global Layout
 */
// Global Layout
$wp_customize->add_section(
	'blogoholic_pro_global_layout',
	array(
		'title' => esc_html__( 'Global Layout', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_general_panel',
	)
);

// Global site layout setting
$wp_customize->add_setting(
	'blogoholic_pro_site_layout',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'wide',
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_site_layout',
	array(
		'section'		=> 'blogoholic_pro_global_layout',
		'label'			=> esc_html__( 'Site layout', 'blogoholic-pro' ),
		'type'			=> 'radio',
		'choices'		=> array( 
			'boxed' => esc_html__( 'Boxed', 'blogoholic-pro' ), 
			'wide' => esc_html__( 'Wide', 'blogoholic-pro' ), 
			'frame' => esc_html__( 'Frame', 'blogoholic-pro' ), 
		),
	)
);

// Global archive layout setting
$wp_customize->add_setting(
	'blogoholic_pro_archive_sidebar',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'right',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_archive_sidebar',
	array(
		'section'		=> 'blogoholic_pro_global_layout',
		'label'			=> esc_html__( 'Archive Sidebar', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'This option works on all archive pages like: 404, search, date, category, "Your latest posts" and so on.', 'blogoholic-pro' ),
		'type'			=> 'radio',
		'choices'		=> array( 
			'left' => esc_html__( 'Left', 'blogoholic-pro' ), 
			'right' => esc_html__( 'Right', 'blogoholic-pro' ), 
			'no' => esc_html__( 'No Sidebar', 'blogoholic-pro' ), 
		),
	)
);

// Global page layout setting
$wp_customize->add_setting(
	'blogoholic_pro_global_page_layout',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'right',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_global_page_layout',
	array(
		'section'		=> 'blogoholic_pro_global_layout',
		'label'			=> esc_html__( 'Global page sidebar', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'This option works only on single pages including "Posts page". This setting can be overridden for single page from the metabox too.', 'blogoholic-pro' ),
		'type'			=> 'radio',
		'choices'		=> array( 
			'left' => esc_html__( 'Left', 'blogoholic-pro' ), 
			'right' => esc_html__( 'Right', 'blogoholic-pro' ), 
			'no' => esc_html__( 'No Sidebar', 'blogoholic-pro' ), 
		),
	)
);

// Global post layout setting
$wp_customize->add_setting(
	'blogoholic_pro_global_post_layout',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'right',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_global_post_layout',
	array(
		'section'		=> 'blogoholic_pro_global_layout',
		'label'			=> esc_html__( 'Global post sidebar', 'blogoholic-pro' ),
		'description'			=> esc_html__( 'This option works only on single posts. This setting can be overridden for single post from the metabox too.', 'blogoholic-pro' ),
		'type'			=> 'radio',
		'choices'		=> array( 
			'left' => esc_html__( 'Left', 'blogoholic-pro' ), 
			'right' => esc_html__( 'Right', 'blogoholic-pro' ), 
			'no' => esc_html__( 'No Sidebar', 'blogoholic-pro' ), 
		),
	)
);

/**
 * Blog/Archive section 
 */
// Blog/Archive section 
$wp_customize->add_section(
	'blogoholic_pro_archive_settings',
	array(
		'title' => esc_html__( 'Archive/Blog', 'blogoholic-pro' ),
		'description' => esc_html__( 'Settings for archive pages including blog page too.', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_general_panel',
	)
);

// Archive excerpt length setting
$wp_customize->add_setting(
	'blogoholic_pro_archive_excerpt_length',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_number_range',
		'default' => 20,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_archive_excerpt_length',
	array(
		'section'		=> 'blogoholic_pro_archive_settings',
		'label'			=> esc_html__( 'Excerpt more length:', 'blogoholic-pro' ),
		'type'			=> 'number',
		'input_attrs'   => array( 'min' => 5 ),
	)
);

// Date enable setting
$wp_customize->add_setting(
	'blogoholic_pro_enable_archive_date',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => true,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_enable_archive_date',
	array(
		'section'		=> 'blogoholic_pro_archive_settings',
		'label'			=> esc_html__( 'Enable date.', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);

// Category enable setting
$wp_customize->add_setting(
	'blogoholic_pro_enable_archive_cat',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => true,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_enable_archive_cat',
	array(
		'section'		=> 'blogoholic_pro_archive_settings',
		'label'			=> esc_html__( 'Enable category.', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);

// blog image enable setting
$wp_customize->add_setting(
	'blogoholic_pro_enable_archive_featured_img',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => true,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_enable_archive_featured_img',
	array(
		'section'		=> 'blogoholic_pro_archive_settings',
		'label'			=> esc_html__( 'Enable featured image.', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);

// Content type setting
$wp_customize->add_setting(
	'blogoholic_pro_enable_archive_content_type',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'excerpt',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_enable_archive_content_type',
	array(
		'section'		=> 'blogoholic_pro_archive_settings',
		'label'			=> esc_html__( 'Content type:', 'blogoholic-pro' ),
		'choices'		=> array(
			'full-content' => esc_html__( 'Full content', 'blogoholic-pro' ), 
			'excerpt' => esc_html__( 'Excerpt', 'blogoholic-pro' ), 
		),
		'type'			=> 'radio',
	)
);

// Pagination type setting
$wp_customize->add_setting(
	'blogoholic_pro_archive_pagination_type',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_select',
		'default' => 'numeric',
	)
);

$archive_pagination_description = '';
$archive_pagination_choices = array( 
			'disable' => esc_html__( '--Disable--', 'blogoholic-pro' ),
			'numeric' => esc_html__( 'Numeric', 'blogoholic-pro' ),
			'older_newer' => esc_html__( 'Older / Newer', 'blogoholic-pro' ),
		);
if ( ! class_exists( 'JetPack' ) ) {
	$archive_pagination_description = sprintf( esc_html__( 'We recommend to install %1$sJetpack%2$s and enable %3$sInfinite Scroll%4$s feature for automatic loading of posts.', 'blogoholic-pro' ), '<a target="_blank" href="http://wordpress.org/plugins/jetpack">', '</a>', '<b>', '</b>' );
} else {
	$archive_pagination_choices['infinite_scroll'] = esc_html__( 'Infinite Load', 'blogoholic-pro' );
}
$wp_customize->add_control(
	'blogoholic_pro_archive_pagination_type',
	array(
		'section'		=> 'blogoholic_pro_archive_settings',
		'label'			=> esc_html__( 'Pagination type:', 'blogoholic-pro' ),
		'description'			=>  $archive_pagination_description,
		'type'			=> 'select',
		'choices'		=> $archive_pagination_choices,
	)
);

/**
 * Single setting section 
 */
// Single setting section 
$wp_customize->add_section(
	'blogoholic_pro_single_settings',
	array(
		'title' => esc_html__( 'Single Posts', 'blogoholic-pro' ),
		'description' => esc_html__( 'Settings for all single posts.', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_general_panel',
	)
);

// Date enable setting
$wp_customize->add_setting(
	'blogoholic_pro_enable_single_date',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => true,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_enable_single_date',
	array(
		'section'		=> 'blogoholic_pro_single_settings',
		'label'			=> esc_html__( 'Enable date.', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);

// Category enable setting
$wp_customize->add_setting(
	'blogoholic_pro_enable_single_cat',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => true,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_enable_single_cat',
	array(
		'section'		=> 'blogoholic_pro_single_settings',
		'label'			=> esc_html__( 'Enable category.', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);

// Tag enable setting
$wp_customize->add_setting(
	'blogoholic_pro_enable_single_tag',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => true,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_enable_single_tag',
	array(
		'section'		=> 'blogoholic_pro_single_settings',
		'label'			=> esc_html__( 'Enable tags.', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);

// Comment enable setting
$wp_customize->add_setting(
	'blogoholic_pro_enable_single_comment',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => true,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_enable_single_comment',
	array(
		'section'		=> 'blogoholic_pro_single_settings',
		'label'			=> esc_html__( 'Enable comment.', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);


// Author enable setting
$wp_customize->add_setting(
	'blogoholic_pro_enable_single_author',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => true,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_enable_single_author',
	array(
		'section'		=> 'blogoholic_pro_single_settings',
		'label'			=> esc_html__( 'Enable author.', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);



// Featured image enable setting
$wp_customize->add_setting(
	'blogoholic_pro_enable_single_featured_img',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => true,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_enable_single_featured_img',
	array(
		'section'		=> 'blogoholic_pro_single_settings',
		'label'			=> esc_html__( 'Enable featured image.', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);

// Pagination enable setting
$wp_customize->add_setting(
	'blogoholic_pro_enable_single_pagination',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => true,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_enable_single_pagination',
	array(
		'section'		=> 'blogoholic_pro_single_settings',
		'label'			=> esc_html__( 'Enable pagination.', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);

/**
 * Single pages setting section 
 */
// Single pages setting section 
$wp_customize->add_section(
	'blogoholic_pro_single_page_settings',
	array(
		'title' => esc_html__( 'Single Pages', 'blogoholic-pro' ),
		'description' => esc_html__( 'Settings for all single pages.', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_general_panel',
	)
);

// Featured image enable setting
$wp_customize->add_setting(
	'blogoholic_pro_enable_single_page_featured_img',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => true,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_enable_single_page_featured_img',
	array(
		'section'		=> 'blogoholic_pro_single_page_settings',
		'label'			=> esc_html__( 'Enable featured image.', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);

/**
 * Reset all settings
 */
// Reset settings section
$wp_customize->add_section(
	'blogoholic_pro_reset_sections',
	array(
		'title' => esc_html__( 'Reset all', 'blogoholic-pro' ),
		'description' => esc_html__( 'Reset all settings to default.', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_general_panel',
	)
);

// Reset sortable order setting
$wp_customize->add_setting(
	'blogoholic_pro_reset_settings',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => false,
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_reset_settings',
	array(
		'section'		=> 'blogoholic_pro_reset_sections',
		'label'			=> esc_html__( 'Reset all settings?', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);

/**
 *
 *
 * Footer copyright
 *
 *
 */
// Footer copyright
$wp_customize->add_section(
	'blogoholic_pro_footer_section',
	array(
		'title' => esc_html__( 'Footer', 'blogoholic-pro' ),
		'priority' => 106,
		'panel' => 'blogoholic_pro_general_panel',
	)
);


// Footer text enable setting
$wp_customize->add_setting(
	'blogoholic_pro_enable_footer_text',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => true,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_enable_footer_text',
	array(
		'section'		=> 'blogoholic_pro_footer_section',
		'label'			=> esc_html__( 'Enable footer text.', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);

// Footer copyright setting
$wp_customize->add_setting(
	'blogoholic_pro_copyright_txt',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_html',
		'default' => $default['blogoholic_pro_copyright_txt'],
		'transport'	=> 'postMessage',
	)
);

$wp_customize->add_control(
	'blogoholic_pro_copyright_txt',
	array(
		'section'		=> 'blogoholic_pro_footer_section',
		'label'			=> esc_html__( 'Copyright text:', 'blogoholic-pro' ),
		'type'			=> 'textarea',
		'active_callback' => 'blogoholic_pro_if_footer_text_enable',
	)
);

$wp_customize->add_setting(
	'blogoholic_pro_power_by_txt',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_html',
		'default' => $default['blogoholic_pro_power_by_txt'],
		'transport'	=> 'postMessage',
	)	
);

$wp_customize->add_control(
	'blogoholic_pro_power_by_txt',
	array(
		'section'		=> 'blogoholic_pro_footer_section',
		'label'			=> esc_html__( 'Power by text:', 'blogoholic-pro' ),
		'type'			=> 'textarea',
		'active_callback' => 'blogoholic_pro_if_footer_text_enable',
	)
);
