<?php
/**
 * Moral Theme Customizer
 *
 * @package Moral
 *
 * topbar
 */

$wp_customize->add_section(
	'blogoholic_pro_topbar',
	array(
		'title' => esc_html__( 'Top bar', 'blogoholic-pro' ),
		'panel' => 'blogoholic_pro_general_panel',
	)
);

// topbar enable settings
$wp_customize->add_setting(
	'blogoholic_pro_topbar',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => false,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_topbar',
	array(
		'section'		=> 'blogoholic_pro_topbar',
		'label'			=> esc_html__( 'Enable Topbar', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);

$wp_customize->add_setting(
	'blogoholic_pro_topbar_social_menu',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => false,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_topbar_social_menu',
	array(
		'section'		=> 'blogoholic_pro_topbar',
		'label'			=> esc_html__( 'Enable Social Menu', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);

$wp_customize->add_setting(
	'blogoholic_pro_topbar_menu',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => false,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_topbar_menu',
	array(
		'section'		=> 'blogoholic_pro_topbar',
		'label'			=> esc_html__( 'Enable Topbar Menu', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);

$wp_customize->add_setting(
	'blogoholic_pro_topbar_search',
	array(
		'sanitize_callback' => 'blogoholic_pro_sanitize_checkbox',
		'default' => false,
	)
);

$wp_customize->add_control(
	'blogoholic_pro_topbar_search',
	array(
		'section'		=> 'blogoholic_pro_topbar',
		'label'			=> esc_html__( 'Enable Search From', 'blogoholic-pro' ),
		'type'			=> 'checkbox',
	)
);

for ($i=1; $i <= 2 ; $i++) { 
	$wp_customize->add_setting(
		'blogoholic_pro_topbar_icons_' . $i,
		array(	
		'sanitize_callback' => 'sanitize_text_field'
		)
	);

	$wp_customize->add_control(
		'blogoholic_pro_topbar_icons_' . $i,
		array(
		'label'       => __('Icon ', 'blogoholic-pro'). $i,
		'description' => sprintf( __('Please input icon as eg: fa-archive. Find Font-awesome icons %1$shere%2$s', 'blogoholic-pro'), '<a href="' . esc_url( 'https://fontawesome.com/v4.7.0/cheatsheet/' ) . '" target="_blank">', '</a>' ),
		'section'     => 'blogoholic_pro_topbar',   	
		'type'        => 'text'
		)
	);

	$wp_customize->add_setting(
			'blogoholic_pro_topbar_textfield_' . $i,
			array(	
			'sanitize_callback' => 'sanitize_text_field'
			)
		);

	$wp_customize->add_control(
		'blogoholic_pro_topbar_textfield_' . $i,
		array(
		'label'       => __('Text Field ', 'blogoholic-pro'). $i,  
		'section'     => 'blogoholic_pro_topbar',   		
		'type'        => 'text'
		)
	);
}