<?php
/**
 * Moral OCDI plugin compatible functions
 *
 * @package Moral
 */

function blogoholic_pro_ctdi_plugin_page_setup( $default_settings ) {
    $default_settings['menu_title']  = esc_html__( 'Moral Theme Demo Import' , 'blogoholic-pro' );

    return $default_settings;
}
add_filter( 'cp-ctdi/plugin_page_setup', 'blogoholic_pro_ctdi_plugin_page_setup' );


function blogoholic_pro_ctdi_import_files() {
    return array(
        array(
            'import_file_name'             => esc_html__( 'Pro', 'blogoholic-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/inc/demo/pro/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/inc/demo/pro/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/inc/demo/pro/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/inc/demo/pro/image.png',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'blogoholic-pro' ),
            'preview_url'                  => 'https://demo.moralthemes.com/blogoholic-pro',
        ),
        array(
            'import_file_name'             => esc_html__( 'Dark', 'blogoholic-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/inc/demo/dark/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/inc/demo/dark/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/inc/demo/dark/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/inc/demo/dark/image.png',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'blogoholic-pro' ),
            'preview_url'                  => 'https://demo.moralthemes.com/blogoholic-pro-dark',
        ),
        array(
            'import_file_name'             => esc_html__( 'Education', 'blogoholic-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/inc/demo/education/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/inc/demo/education/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/inc/demo/education/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/inc/demo/education/image.png',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'blogoholic-pro' ),
            'preview_url'                  => 'https://demo.moralthemes.com/blogoholic-pro-education',
        ),
        array(
            'import_file_name'             => esc_html__( 'News', 'blogoholic-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/inc/demo/news/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/inc/demo/news/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/inc/demo/news/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/inc/demo/news/image.png',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'blogoholic-pro' ),
            'preview_url'                  => 'https://demo.moralthemes.com/blogoholic-pro-news',
        ),
        array(
            'import_file_name'             => esc_html__( 'Magazine', 'blogoholic-pro' ),
            'categories'                   => array( ),
            'local_import_file'            => get_template_directory() . '/inc/demo/magazine/content.xml',
            'local_import_widget_file'     => get_template_directory() . '/inc/demo/magazine/widgets.wie',
            'local_import_customizer_file' => get_template_directory() . '/inc/demo/magazine/customizer.dat',
            'import_preview_image_url'     => get_template_directory_uri() . '/inc/demo/magazine/image.png',
            'import_notice'                => esc_html__( 'Please wait for a few minutes, do not close the window or refresh the page until the data is imported.', 'blogoholic-pro' ),
            'preview_url'                  => 'https://demo.moralthemes.com/blogoholic-pro-magazine',
        ),
    );
}
add_filter( 'cp-ctdi/import_files', 'blogoholic_pro_ctdi_import_files' );



function blogoholic_pro_ctdi_after_import_setup() {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Primary', 'nav_menu' );
    $social = get_term_by('name', 'Social', 'nav_menu');
    $secondary = get_term_by('name', 'Secondary', 'nav_menu');

    set_theme_mod( 'nav_menu_locations', array(
            'primary' => $main_menu->term_id,
            'social' => $social->term_id,
            'secondary' => $secondary->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home' );
    $blog_page_id  = get_page_by_title( 'Blog' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'cp-ctdi/after_import', 'blogoholic_pro_ctdi_after_import_setup' );
