<?php
/**
 * Theme updater 
 *
 * @package Theme Palace
 * @subpackage Pikture Pro
 * @since Pikture Pro 1.0.0
 */

// Includes the files needed for the theme updater
if ( !class_exists( 'EDD_Theme_Updater_Admin' ) ) {
	require get_template_directory() . '/inc/updater/theme-updater-admin.php';
}

// Loads the updater classes
$updater = new EDD_Theme_Updater_Admin(

	// Config settings
	$config = array(
		'remote_api_url' => 'https://themepalace.com', // Site where EDD is hosted
		'item_name'      => 'blogoholic Pro', // Name of theme
		'theme_slug'     => 'blogoholic-pro', // Theme slug
		'version'        => '1.0.4', // The current version of this theme
		'author'         => 'Moral Themes', // The author of this theme
		'download_id'    => '', // Optional, used for generating a license renewal link
		'renew_url'      => 'https://themepalace.com/my-account' // Optional, allows for a custom license renewal link
	),

	// Strings
	$strings = array(
		'theme-license'             => __( 'Theme License', 'blogoholic-pro' ),
		'enter-key'                 => __( 'Enter your theme license key.', 'blogoholic-pro' ),
		'license-key'               => __( 'License Key', 'blogoholic-pro' ),
		'license-action'            => __( 'License Action', 'blogoholic-pro' ),
		'deactivate-license'        => __( 'Deactivate License', 'blogoholic-pro' ),
		'activate-license'          => __( 'Activate License', 'blogoholic-pro' ),
		'status-unknown'            => __( 'License status is unknown.', 'blogoholic-pro' ),
		'renew'                     => __( 'Renew?', 'blogoholic-pro' ),
		'unlimited'                 => __( 'unlimited', 'blogoholic-pro' ),
		'license-key-is-active'     => __( 'License key is active.', 'blogoholic-pro' ),
		'expires%s'                 => __( 'Expires %s.', 'blogoholic-pro' ),
		'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'blogoholic-pro' ),
		'license-key-expired-%s'    => __( 'License key expired %s.', 'blogoholic-pro' ),
		'license-key-expired'       => __( 'License key has expired.', 'blogoholic-pro' ),
		'license-keys-do-not-match' => __( 'License keys do not match.', 'blogoholic-pro' ),
		'license-is-inactive'       => __( 'License is inactive.', 'blogoholic-pro' ),
		'license-key-is-disabled'   => __( 'License key is disabled.', 'blogoholic-pro' ),
		'site-is-inactive'          => __( 'Site is inactive.', 'blogoholic-pro' ),
		'license-status-unknown'    => __( 'License status is unknown.', 'blogoholic-pro' ),
		'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'blogoholic-pro' ),
		'update-available'          => __('<strong>%1$s %2$s</strong> is available. <a href="%3$s" class="thickbox" title="%4$s">Check out what\'s new</a> or <a href="%5$s"%6$s>update now</a>.', 'blogoholic-pro' )
	)

);
