<?php
/**
 * Template part for displaying front page imtroduction.
 *
 * @package Moral
 */

// Get the content type.
$breakingnews = get_theme_mod( 'blogoholic_pro_breakingnews', 'disable' );
$breakingnews_num    = get_theme_mod( 'blogoholic_pro_breakingnews_num', 6 ) ;
// Bail if the section is disabled.
if ( 'disable' === $breakingnews ) {
    return;
}

// Query if the content type is either post or page.
if ( $breakingnews == 'cat' )  {
    $cat_content_id = get_theme_mod( 'blogoholic_pro_breakingnews_cat' );
    $args = array(
        'cat' => $cat_content_id,   
    );
}
?>
<div id="breaking-news" class="relative">
    <div class="wrapper">
        <div class="breaking-news-wrapper clear">
            <h2 class="news-title">Breaking News</h2>
            <div class="breaking-news-slider" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": true, "speed": 1000, "dots": false, "arrows":true, "autoplay": true, "draggable": true, "fade": true }'>
                <?php
                if ( $breakingnews == 'recent' ) {
                    $args = array(
                        'post_type' => 'post',
                    );
                }
                $query = new WP_Query( $args );
                if ( $query->have_posts() ) {
                    while ( $query->have_posts() ) {
                        $query->the_post();
                ?>  
                    <article>
                        <div class="breaking-news-item-wrapper">
                            <header class="entry-header">
                                <h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                            </header>
                        </div><!-- .breaking-news-item-wrapper -->
                    </article>

                <?php   }
                    wp_reset_postdata();
                } ?>
            </div><!-- .breaking-news-slider -->
        </div><!-- .breaking-news-wrapper -->
    </div>
</div><!-- #breaking-news -->