<?php
/**
 * Template part for displaying front page imtroduction.
 *
 * @package Moral
 */

// Get the content type.
$category = get_theme_mod( 'blogoholic_pro_category', 'disable' );

// Bail if the section is disabled.
if ( 'disable' === $category ) {
	return;
}
$categories = array();
for ($i=1; $i < 4 ; $i++) { 
	if ( get_theme_mod( 'blogoholic_pro_category_cat_'.$i, '' ) !== '' ) {
		$categories[] = get_theme_mod( 'blogoholic_pro_category_cat_'.$i );
	} 
}	
?>
<div id="category-post-slider" class="page-section">
    <div class="wrapper">
        <div class="category-slider-wrapper col-3">
        	<?php foreach ($categories as $category) { ?>

    			<div class="hentry">
                    <div class="section-header">
                        <h2 class="section-title"><?php echo esc_html( get_the_category_by_ID($category) ); ?></h2>
                    </div><!-- .section-header -->

                    <div class="travel-slider" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": true, "speed": 1000, "dots": false, "arrows":true, "autoplay": false, "draggable": true, "fade": false }'>
                        <?php  
                            $query = new WP_Query( array(
                                    'cat' => $category,   
                                ) );
                            $section_data = array();
                            if ( $query->have_posts() ) {
                                while ( $query->have_posts() ) {
                                    $query->the_post();
                                    $page_post['title']  = get_the_title();
                                    $page_post['url']    = get_the_permalink();
                                    $page_post['image']  = get_the_post_thumbnail_url( get_the_id(), 'thumbnail' );
                                    $page_post['id' ]    = get_the_id();
                                    array_push( $section_data, $page_post );
                                }
                            }
                            wp_reset_postdata();
                            $count = count($section_data)/4;
                            if ( $count < 1 ) {
                                $count = 1;
                            }elseif ( $count > 1 && is_float($count)) {
                                $count = intval($count)+1;
                            }
                            $break = 0;
                            for ($i=0; $i < $count ; $i++) { ?>
                                <div class="slider-wrapper">
                                    <?php for ( $j= $break ; $j < count($section_data) ; $j++): 
                                        $banner_thumbnail = !empty( $section_data[$j]['image'] ) ? $section_data[$j]['image'] : get_template_directory_uri(). '/assets/img/no-featured-image.jpg';
                                    ?>
                                        <article>
                                            <div class="featured-image" style="background-image: url('<?php echo esc_url( $banner_thumbnail ); ?>');"></div>
                                            <div class="entry-container">
                                                <header class="entry-header">
                                                    <h2 class="entry-title"><a href="<?php echo esc_url( $section_data[$j]['url'] ); ?>"><?php echo esc_html( $section_data[$j]['title'] ); ?></a></h2>
                                                </header>
                                                <div class="entry-meta">
                                                     <?php blogoholic_pro_posted_on($section_data[$j]['id']) ; ?>
                                                </div><!-- .entry-meta -->
                                            </div><!-- .entry-container -->
                                        </article>
                                        <?php if ( $j%3 == 0 && $j !== 0): 
                                            $break = $j+1;
                                            break;
                                        endif ?>
                                    <?php endfor; ?>
                                </div>
                           <?php }
                        ?>
                        </div>
                    </div>
        	<?php	}  	?>
        </div>
    </div>
</div>