<?php
/**
 * Template part for displaying front page imtroduction.
 *
 * @package Moral
 */

// Get the content type.
$editor = get_theme_mod( 'blogoholic_pro_editor', 'recent' );
$editor_num = get_theme_mod( 'blogoholic_pro_editor_num', 4 ) ;
// Bail if the section is disabled.
if ( 'disable' === $editor ) {
    return;
}

// Query if the content type is either post or page.
if (  in_array( $editor, array( 'post', 'page' ) ) ) {
    $content_id = array();
    if ( 'post' === $editor ) {
        for ( $i=1; $i <= $editor_num; $i++ ) { 
            $content_id[] = get_theme_mod( "blogoholic_pro_editor_{$editor}_" . $i );
            } 
    }else {
        for ( $i=1; $i <= $editor_num; $i++ ) { 
            $content_id[] = get_theme_mod( "blogoholic_pro_editor_{$editor}_" . $i );
        }
    }
    $args = array(
        'post_type' => $editor,
        'post__in' => (array)$content_id,   
        'orderby'   => 'post__in',
        'posts_per_page' => absint( $editor_num ),
        'ignore_sticky_posts' => true,
    );

} else {
    $cat_content_id = get_theme_mod( 'blogoholic_pro_editor_cat' );
    $args = array(
        'cat' => $cat_content_id,   
        'posts_per_page' =>  absint( $editor_num ),
    );
}
?>
<div id="editor-slider" class="page-section no-padding-top">
    <div class="wrapper">
        <div class="section-header">
            <h2 class="section-title">
                <?php echo esc_html( get_theme_mod( 'blogoholic_pro_editor_title', __( 'Editors Picks', 'blogoholic-pro') ) ) ; ?>
            </h2>
        </div><!-- .seection-header -->

        <div class="editor-wrapper" data-slick='{"slidesToShow": 3, "slidesToScroll": 1, "infinite": true, "speed": 1000, "dots": false, "arrows":true, "autoplay": false, "draggable": true, "fade": false }'>
            <?php
            if ( $editor == 'recent' ) {
                $args = array(
                    'post_type' => 'post',
                    'posts_per_page' => absint( $editor_num ),
                );
            }
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) {
                while ( $query->have_posts() ) {
                    $query->the_post();
                    $banner_thumbnail = !empty( get_the_post_thumbnail_url( ) ) ? get_the_post_thumbnail_url( get_the_id(), 'medium' ) : get_template_directory_uri(). '/assets/img/no-featured-image.jpg';
            ?>
            <article>
                <div class="featured-image">
                    <a href="<?php the_permalink() ; ?>" tabindex="-1"><img src="<?php echo esc_url( $banner_thumbnail ) ; ?>"></a>
                </div><!-- .featured-image -->

                <div class="entry-container">
                    <header class="entry-header">
                        <h2 class="entry-title">
                            <a href="<?php the_permalink() ; ?>" tabindex="-1">
                                <?php the_title(); ?>
                            </a>
                        </h2>
                    </header>

                    <div class="entry-meta">
                        <?php blogoholic_pro_posted_on() ; ?>
                    </div><!-- .entry-meta -->
                </div><!-- .entry-container -->
            </article>
            <?php   }
            wp_reset_postdata();
        } ?>
        </div>
    </div><!-- .wrapper -->
</div><!-- #editor-slider -->