<?php
/**
 * Template part for displaying front page imtroduction.
 *
 * @package Moral
 */

// Get the content type.
$fitness = get_theme_mod( 'blogoholic_pro_fitness', 'recent' );
$fitness_num    = $fitness_num = get_theme_mod( 'blogoholic_pro_fitness_num', 3 );
// Bail if the section is disabled.
if ( 'disable' === $fitness ) {
    return;
}

// Query if the content type is either post or page.
if (  in_array( $fitness, array( 'post', 'page' ) ) ) {
    $content_id = array();
    if ( 'post' === $fitness ) {
        for ( $i=1; $i <= $fitness_num; $i++ ) { 
            $content_id[] = get_theme_mod( "blogoholic_pro_fitness_{$fitness}_" . $i );
            } 
    }else {
        for ( $i=1; $i <= $fitness_num; $i++ ) { 
            $content_id[] = get_theme_mod( "blogoholic_pro_fitness_{$fitness}_" . $i );
        }
    }
    $args = array(
        'post_type' => $fitness,
        'post__in' => (array)$content_id,   
        'orderby'   => 'post__in',
        'posts_per_page' => absint( $fitness_num ),
        'ignore_sticky_posts' => true,
    );

} else {
    $cat_content_id = get_theme_mod( 'blogoholic_pro_fitness_cat' );
    $args = array(
        'cat' => $cat_content_id,   
        'posts_per_page' =>  absint( $fitness_num ),
    );
}
?>
<div id="fitness" class="page-section">
    <div class="wrapper">
        <div class="section-header">
            <h2 class="section-title"><?php echo esc_html( get_theme_mod( 'blogoholic_pro_fitness_title', __('Fitness Articles', 'blogoholic-pro') ) ); ?></h2>
        </div>

        <div class="fitness-wrapper col-2 clear">
        <?php
        if ( $fitness == 'recent' ) {
                $args = array(
                    'post_type' => 'post',
                    'posts_per_page' => absint($fitness_num),
                );
            }
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) {
            $content = array();
            while ( $query->have_posts() ) {
                $query->the_post();
                $detail['image']   = get_the_post_thumbnail_url( get_the_id(), 'medium-large' );
                $detail['url']     = get_the_permalink( );
                $detail['id']      = get_the_id();
                $detail['title']   = get_the_title();
                $detail['content']  = wp_trim_words( get_the_content(), 20, '  ....' );
                array_push( $content, $detail );
            }
            wp_reset_postdata();
        }
        if ( empty($content) ) {
            return;
        }
        $article_control = 1;
        $hentry_control = 0;
        for ($i=0; $i < 2 ; $i++) { 
        ?>
        <div class="hentry">
            <?php 
            for ( $j=0; $j < count($content) ; $j++ ) { 
                    if ( count($content) == 1 ) {
                        $hentry_control = 1;
                    } 
                    if ( $article_control == 0 ) {
                        if ( in_array( $j, array(0,3,6,9) ) ) {
                            $j = $j+1;
                        }
                        if ( $j == count($content) ) {
                            break;
                        }
                    }
                    $banner_thumbnail = !empty( $content[$j]['image'] ) ? $content[$j]['image'] : get_template_directory_uri(). '/assets/img/no-featured-image.jpg';
            ?>
                <article>
                    <div class="featured-image" style="background-image: url(<?php echo esc_url( $banner_thumbnail ) ?>);"> 
                        <a href="<?php echo esc_url( $content[$j]['url'] ) ; ?>" class="post-thumbnail-link"></a>
                    </div>                       
                    <div class="entry-container">
                        <header class="entry-header">
                            <h2 class="entry-title"><a href="<?php echo esc_url( $content[$j]['url'] ) ; ?>"><?php echo esc_html($content[$j]['title']); ?></a></h2>
                        </header>

                        <div class="entry-content">
                           <?php echo esc_html($content[$j]['content']) ;?>
                        </div>
                    
                        <div class="entry-meta">
                            <?php blogoholic_pro_posted_on($content[$j]['id']) ; ?>
                        </div><!-- .entry-meta -->
                    </div><!-- .entry-container -->                    
                </article>
                <?php
                     
                    if ( $article_control == 1 ) {                    
                        $j = $j+2;
                    }
                ?>
            <?php } $article_control = 0 ; ?>
        </div>
        <?php }  ?>
        </div><!-- .fitness-wrapper -->
    </div><!-- .wrapper -->
</div><!-- #fitness -->    

                   