<?php
/**
 * Template part for displaying front page imtroduction.
 *
 * @package Moral
 */

// Get the content type.
$recent = get_theme_mod( 'blogoholic_pro_recent', 'recent' );
$recent_num    = $recent_num = get_theme_mod( 'blogoholic_pro_recent_num', 3 ); ;
// Bail if the section is disabled.
if ( 'disable' === $recent ) {
    return;
}

// Query if the content type is either post or page.
if (  in_array( $recent, array( 'post', 'page' ) ) ) {
    $content_id = array();
    if ( 'post' === $recent ) {
        for ( $i=1; $i <= $recent_num; $i++ ) { 
            $content_id[] = get_theme_mod( "blogoholic_pro_recent_{$recent}_" . $i );
            } 
    }else {
        for ( $i=1; $i <= $recent_num; $i++ ) { 
            $content_id[] = get_theme_mod( "blogoholic_pro_recent_{$recent}_" . $i );
        }
    }
    $args = array(
        'post_type' => $recent,
        'post__in' => (array)$content_id,   
        'orderby'   => 'post__in',
        'posts_per_page' => absint( $recent_num ),
        'ignore_sticky_posts' => true,
    );

} else {
    $cat_content_id = get_theme_mod( 'blogoholic_pro_recent_cat' );
    $args = array(
        'cat' => $cat_content_id,   
        'posts_per_page' =>  absint( $recent_num ),
    );
}
?>
<div id="recent" class="page-section">
    <div class="wrapper">
        <div class="section-header">
            <h2 class="section-title"><?php echo esc_html( get_theme_mod( 'blogoholic_pro_recent_title', __('Recent Articles', 'blogoholic-pro') ) ); ?></h2>
        </div>

        <div class="recent-wrapper col-2 clear">
        <?php
        if ( $recent == 'recent' ) {
                $args = array(
                    'post_type' => 'post',
                    'posts_per_page' => absint( $recent_num ),
                );
            }
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) {
            $content = array();
            while ( $query->have_posts() ) {
                $query->the_post();
                $detail['image']   = get_the_post_thumbnail_url( get_the_id(), 'medium-large' );
                $detail['url']     = get_the_permalink( );
                $detail['id']      = get_the_id();
                $detail['title']   = get_the_title();
                $detail['content']  = wp_trim_words( get_the_content(), 10, '  ....' );
                array_push( $content, $detail );
            }
            wp_reset_postdata();
        }
        if ( empty($content) ) {
            return;
        }
        $article_control = 1;
        $hentry_control = 0;
        $end = 0;
        for ($i=0; $i < 2 ; $i++) { 
            if ( $article_control == 0 ) {
                $end = 1;                    
            }
            if ( $hentry_control == 1 ) {
                break;
            }
        ?>
        <div class="hentry">
            <?php if ( $article_control == 0 ): ?>
                <div class="recent-article-wrapper">
            <?php endif ?>
            <?php 
            for ( $j=0; $j < count($content) ; $j++ ) {
                if ( count($content) == 1 ) {
                    $hentry_control = 1;
                 } 
                if ( $article_control == 0 ) {
                    if ( in_array( $j, array(0,3,6,9) ) ) {
                        $j = $j+1;
                    }
                    if ( $j == count($content) ) {
                        break;
                    }
                }
                $banner_thumbnail = !empty( $content[$j]['image'] ) ? $content[$j]['image'] : get_template_directory_uri(). '/assets/img/no-featured-image.jpg';
            ?>
                <article>
                    <div class="featured-image" style="background-image: url(<?php echo esc_url( $banner_thumbnail ) ?>);"><a href="<?php echo esc_url( $content[$j]['url'] ) ; ?>" class="post-thumbnail-link"></a>
                    <?php if ( $article_control == 0 ): ?>
                    </div>
                    <?php endif ?>
                        <?php if ( $article_control == 1 ): ?>
                        <div class="overlay"></div>
                        <?php endif ?>
                       
                        <div class="entry-container">
                            <span class="cat-links">
                                <?php the_category( '','' ,$content[$j]['id'] ); ?>
                            </span><!-- .cat-links -->
                            <header class="entry-header">
                                <h2 class="entry-title"><a href="<?php echo esc_url( $content[$j]['url'] ) ; ?>"><?php echo esc_html($content[$j]['title']); ?></a></h2>
                            </header>
                            <?php if ( $article_control == 0 ): ?>
                                <div class="entry-content">
                                   <?php echo esc_html($content[$j]['content']) ;?>
                                </div>
                            <?php endif; ?>
                            
                            <div class="entry-meta">
                                <?php blogoholic_pro_posted_on($content[$j]['id']) ; ?>
                            </div><!-- .entry-meta -->
                        </div><!-- .entry-container -->
                    <?php if ( $article_control == 1 ): ?>
                    </div>   
                    <?php endif ?>
                    
                </article>
                <?php                     
                    if ( $article_control == 1 ) {                    
                        $j = $j+2;
                    }
                ?>
            <?php } $article_control = 0 ;?>
            <?php if ( $end == 1 ): 
            ?>
            </div>
           <?php endif ?>
        </div>
        <?php }  ?>
        </div><!-- .recent-wrapper -->
    </div><!-- .wrapper -->
</div><!-- #recent -->    

                   