/*------------------------------------------------
                ANIMATION
------------------------------------------------*/
( function( $ ) {
    $(window).load(function(){

    function onScrollInit( items, trigger ) {
        items.each( function() {
        var osElement = $(this),
            osAnimationClass = osElement.attr('data-os-animation'),
            osAnimationDelay = osElement.attr('data-os-animation-delay');
            osAnimationDuration = osElement.attr('data-os-animation-duration');

            osElement.css({
                '-webkit-animation-delay':      osAnimationDelay,
                '-moz-animation-delay':         osAnimationDelay,
                'animation-delay':              osAnimationDelay,
                '-webkit-animation-duration':   osAnimationDuration,
                '-moz-animation-duration':      osAnimationDuration,
                'animation-duration':           osAnimationDuration
            });

            var osTrigger = ( trigger ) ? trigger : osElement;

            osTrigger.waypoint(function() {
                osElement.addClass('animated').addClass(osAnimationClass);
                },{
                    triggerOnce: true,
                    offset: '90%'
            });
        });
    }
    onScrollInit( $('.os-animation') );
    onScrollInit( $('.staggered-animation'), $('.staggered-animation-container') );
});

}) ( jQuery );
/*------------------------------------------------
                END ANIMATION
------------------------------------------------*/
