( function( $ ) {
    // Relocate Jetpack sharing buttons down into the comments form
    jQuery( document ).ready( function( $ ) {
        jQuery( '.share-blog' ).html( jQuery( '.sharedaddy' ) );
    } );

    $(window).load(function(){

    /*******************PRELOADER*******************/

     $('#loader').delay(10).fadeOut('slow');
     $('#loader-container').delay(10).fadeOut('slow');
     $('body').delay(10).css({'overflow-x':'hidden'});

    /*******************END PRELOADER**************/

    /******************STICKY HEADER**************/

    $(window).scroll(function() {
        var scroll = $(window).scrollTop();
        var position = $('.make-sticky').position();

        if ( position ) {
            if ( scroll > position.top) {
               $(".make-sticky").addClass("is-sticky");
            }
            else {
               $(".make-sticky").removeClass("is-sticky");
            }
        }
    });

    if($('.mega-menu .sub-menu ul').hasClass('sub-menu'))
    {
        $('.mega-menu .sub-menu ul').removeClass('sub-menu');
    }

    $(".top-bar .social-icons li").addClass("icon-animation icon-hover-effect");

    $('.topbar-dropdown-toggle').click(function(){
        $('.top-bar.align-left .container').slideToggle();
    });
    /*******************END STICKY HEADER**************/

    /*********************BACK TO TOP******************/

     $(window).scroll(function(){
        if ($(this).scrollTop() > 1) {
        $('.backtotop').css({bottom:"25px"});
        } else {
        $('.backtotop').css({bottom:"-100px"});
        }
        });
        $('.backtotop').click(function(){
        $('html, body').animate({scrollTop: '0px'}, 1200);
        return false;
        });
    /***************END BACK TO TOP**************/
     $('.menu-toggle').click(function(){
        $('.nav-menu').slideToggle();
        $('#search').fadeOut();
        $('.site-header').toggleClass('menu-open');
     });

    $('.main-navigation .menu-item-has-children > a').after('<button class="dropdown-toggle" aria-expanded="false"><span class="screen-reader-text">expand child menu</span></button>');

    $('.main-navigation button.dropdown-toggle').click(function() {
        $(this).toggleClass('active');
        $(this).parent().find('.sub-menu').first().slideToggle();
    });

    /***************END SCROLL DOWN**************/

    $('.search-btn').click(function(){
        $('#search').fadeToggle();
        $('#search input[type="search"]').focus();
    });
    $('#close-search').click(function(){
        $('#search').fadeOut();
    });

    $(document).click(function (e) {
      var container = $("#masthead");
       if (!container.is(e.target) && container.has(e.target).length === 0) {
            $('#search').fadeOut();
        }
    });

    $(document).keyup(function(e) {
        if (e.keyCode === 27) {
            $('#search').fadeOut();
        }
    });
        /**********START PORTFOLIO****************/
    var $container = $('.portfolio'),
        colWidth = function () {
            var w = $container.width(),
                columnNum = 1,
                columnWidth = 0;
            if (w > 1200) {
                columnNum  = 3;
            }
            else if (w > 900) {
                columnNum  = 3;
            }
            else if (w > 600) {
                columnNum  = 3;
            }
            else if (w > 300) {
                columnNum  = 2;
            }
            columnWidth = Math.floor(w/columnNum);
            $container.find('.portfolio-item').each(function() {
                var $item = $(this),
                    multiplier_w = $item.attr('class').match(/item-w(\d)/),
                    multiplier_h = $item.attr('class').match(/item-h(\d)/),
                    width = multiplier_w ? columnWidth*multiplier_w[1]-0 : columnWidth-5,
                    height = multiplier_h ? columnWidth*multiplier_h[1]*1-5 : columnWidth*0.5-5;
                $item.css({
                    width: width,
                    height: height
                });
            });
            return columnWidth;
        }

        function refreshWaypoints() {
            setTimeout(function() {
            }, 1000);
        }

        $('nav.portfolio-filter ul a').on('click', function() {
            var selector = $(this).attr('data-filter');
            $container.isotope({ filter: selector }, refreshWaypoints());
            $('nav.portfolio-filter ul a').removeClass('active');
            $(this).addClass('active');
            return false;
        });

        function setPortfolio() {
            setColumns();
            $container.isotope('reLayout');
        }

        isotope = function () {
            $container.isotope({
                resizable: true,
                itemSelector: '.portfolio-item',
                layoutMode : 'masonry',
                gutter: 0,
                masonry: {
                    columnWidth: colWidth(),
                    gutterWidth: 10
                }
            });
        };
    isotope();
    /**********END PORTFOLIO****************/

    /*******************PIE CHART***********/
    $('#pie-chart-1').pieChart({
        barColor: '#149B9B',
        trackColor: '#9FA0A0',
        lineCap: 'butt',
        lineWidth: 15,
        animate: {duration: 9000, enabled: true},
        onStep: function (from, to, percent) {
            $(this.element).find('.pie-value').text(Math.round(percent) + '%');
        }
    });

    $('#pie-chart-2').pieChart({
        barColor: '#676766',
        trackColor: '#9FA0A0',
        lineCap: 'butt',
        lineWidth: 15,
        animate: {duration: 9000, enabled: true},
        onStep: function (from, to, percent) {
            $(this.element).find('.pie-value').text(Math.round(percent) + '%');
        }
    });

    $('#pie-chart-3').pieChart({
        barColor: '#ECCD52',
        trackColor: '#9FA0A0',
        lineCap: 'butt',
        lineWidth: 15,
        animate: {duration: 9000, enabled: true},
        onStep: function (from, to, percent) {
            $(this.element).find('.pie-value').text(Math.round(percent) + '%');
        }
    });

    $('#pie-chart-4').pieChart({
        barColor: '#EF3F37',
        trackColor: '#9FA0A0',
        lineCap: 'butt',
        lineWidth: 15,
        animate: {duration: 9000, enabled: true},
        onStep: function (from, to, percent) {
            $(this.element).find('.pie-value').text(Math.round(percent) + '%');
        }
    });

    /**********END PIE CHART****************/

    /******************COUNTER**************/

    function count($this){
        var current = parseInt($this.html(), 10);
        current = current + 1; /* Where 50 is increment */
        $this.html(++current);
        if(current > $this.data('count')){
            $this.html($this.data('count'));
        }
        else {
            setTimeout(function(){count($this)}, 50);
        }
    }

    $(".stat-count").each(function() {
        $(this).data('count', parseInt($(this).html(), 10));
        $(this).html('0');
        count($(this));
    });

    /**********END COUNTER****************/


    /***********WIDE AND BOXED LAYOUTS*************/

    $('.boxed').click(function() {
        $('body').addClass('boxed');
    });

    $('.wide').click(function() {
        $('body').removeClass('boxed');
        $('body').addClass('wide');
    });
    
    /**********END WIDE AND BOXED LAYOUT****************/

    });
    /**************END JQUERY***************************/
} )( jQuery );
