<?php
	// You can start editing here -- including this comment!
	if ( have_comments() ) : ?>
		<div class="comments-list os-animation" data-os-animation="fadeIn" data-os-animation-delay="0.3s" data-os-animation-duration="2s">
		  	<h4>
			<?php
				$comments_number = get_comments_number();
				if ( 1 === $comments_number ) {
					printf(	/* translators: %s: post title */
						_x( 'One comment on %1$s', 'comments title', 'business-park-pro' ), get_the_title()
					);
				} else {
					printf( // WPCS: XSS OK.
						/* translators: 1: number of comments, 2: post title */
						esc_html( _nx(
							'%1$s comment on %2$s',
							'%1$s comments on %2$s',
							$comments_number,
							'comments title',
							'business-park-pro'
						) ),
						number_format_i18n( $comments_number ),
						get_the_title()
					);
				}
			?>
			</h4>
			<?php
				wp_list_comments( array(
					'style'      => 'div',
					'short_ping' => true,
					'max_depth'	 => 3
				) );
			?>

			<?php the_comments_navigation(); ?>


		</div><!--end comment-list-->
	<?php endif; // Check for have_comments().?>
	<div class="comment-form os-animation" data-os-animation="fadeIn" data-os-animation-delay="0.3s" data-os-animation-duration="2s">
	<?php
	$comments_args = array(
			'title_reply' => esc_html__( 'YOUR COMMENT', 'business-park-pro' ),
			'comment_field' => '<textarea id="comments" class="form-control" placeholder="'.esc_attr__( 'YOUR COMMENT', 'business-park-pro' ).'" rows="6" name="comment"></textarea><div class="contact-icon message-icon bg-light-grey"><i class="fa fa-quote-left"></i></div>',
			'comment_notes_before' => '',
			'submit_button' => '<input type="submit" class="form-control" value="' . esc_attr__( 'POST COMMENT', 'business-park-pro' ) . '"><i class="fa fa-long-arrow-right"></i>'
			);
	comment_form( $comments_args );?>
	</div>
