<?php
/**
 * Navigation info 
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */
$options = business_park_get_theme_options();

$menu_class = '';
if ( 'mega' == $options['primary_menu_type'] ) {
   $menu_class = 'mega-menu';
}

if ( has_nav_menu( 'top' ) ) {

  wp_nav_menu( 
    array(
        'theme_location'  => 'top',
        'container'       => 'nav',
        'container_id'    => 'site-navigation',
        'container_class' => 'main-navigation' . esc_attr( $menu_class ),
        'menu_id'         => 'primary-menu',
        'menu_class'      => 'menu nav-menu',
        'items_wrap'      => '<button class="menu-toggle icon"><i class="fa fa-bars"></i></button><ul id = "%1$s" class = "%2$s">%3$s</ul>',
        'depth'           => 0,
    )
   );
}
?>
<div class="search" id="search">
    <div class="container">
        <form role="search" method="get" class="search-form" action="<?php echo esc_url(home_url( '/' ) ); ?>">
          <input type="search" class="search-field"
              placeholder="<?php echo esc_attr_x( 'Search...', 'placeholder', 'business-park-pro' ) ?>"
              value="<?php echo get_search_query() ?>" name="s"
              title="<?php echo esc_attr_x( 'Search for:', 'label', 'business-park-pro' ) ?>" />
          <a href="#."><i class="fa fa-close" id="close-search"></i></a>
          <button type="submit" class="search-submit" value=""><i class="fa fa-search"></i></button>
        </form>
   </div><!-- end .container -->
</div><!-- end #search -->
