<?php
/**
 * Business Park core file.
 *
 * This is the template that includes all the other files for core featured of Business park
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */

/**
 * Load theme updater functions.
 * Action is used so that child themes can easily disable.
 */

function prefix_theme_updater() {
  if( is_admin() ) {
    require get_template_directory() . '/updater/theme-updater.php';
  }
}
add_action( 'after_setup_theme', 'prefix_theme_updater' );

/**
 * Include options function.
 */
require get_template_directory() . '/inc/options.php';




// Load customizer defaults values
require get_template_directory() . '/inc/customizer/defaults.php';


/**
 * Merge values from default options array and values from customizer
 *
 * @return array Values returned from customizer
 * @since Business Park Pro 2.0.0
 */
function business_park_get_theme_options() {
  $business_park_default_options = business_park_get_default_theme_options();

  return array_merge( $business_park_default_options , get_theme_mod( 'business_park_theme_options', $business_park_default_options ) ) ;
}


/**
  * Write message for featured image upload
  *
  * @return array Values returned from customizer
  * @since Business Park Pro 2.0.0
*/
function business_park_slider_image_instruction( $content, $post_id ) {
  $allowed = array( 'page' );
  if ( in_array( get_post_type( $post_id ), $allowed ) ) {
    return $content .= '<p><b>' . esc_html__( 'Note', 'business-park-pro' ) . ':</b>' . esc_html__( ' The recommended size for image is 1920px by 1080px while using it for slider', 'business-park-pro' ) . '</p>';
  } elseif ( 'jetpack-testimonial' == get_post_type( $post_id ) ) {
    return $content .= '<p><b>' . esc_html__( 'Note', 'business-park-pro' ) . ':</b>' . esc_html__( ' The recommended size for image is 340px by 340px while using it for testimonial', 'business-park-pro' ) . '</p>';
  }
   return $content;
}
add_filter( 'admin_post_thumbnail_html', 'business_park_slider_image_instruction', 10, 2);


if ( ! function_exists( 'business_park_alter_comment_form_fields' ) ) {
  /**
   * Alter the comment form fields
   * @param  array Array of fields to be customized
   * @return array Array of customized fields
   */
  function business_park_alter_comment_form_fields($fields){
      $fields['url'] = '';  //removes website field
      $fields['author'] = '<input id="author" class="form-control" type="text" placeholder="'.esc_attr__( 'NAME', 'business-park-pro' ). '" name="author"><div class="contact-icon bg-green"><i class="fa fa-user"></i></div>';
      $fields['email'] = '<input id="email" class="form-control" type="text" placeholder="'.esc_attr__( 'EMAIL ADDRESS', 'business-park-pro' ).'" name="email"><div class="contact-icon bg-light-grey"><i class="fa fa-envelope"></i></div>';

      return $fields;
  }
  add_filter('comment_form_default_fields','business_park_alter_comment_form_fields');
}

/**
 * Add helper functions.
 */
require get_template_directory() . '/inc/woocommerce.php';

/**
 * Add helper functions.
 */
require get_template_directory() . '/inc/helpers.php';

/**
 * Add structural hooks.
 */
require get_template_directory() . '/inc/structure.php';


/**
 * Add metabox
 */
require get_template_directory() . '/inc/metabox.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/sections/sections.php';

/**
 * Custom widget additions.
 */
require get_template_directory() . '/inc/widgets/widgets.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer/customizer.php';

require get_template_directory() . '/inc/wptt-webfont-loader.php';

/**
* TGM plugin additions.
*/
require get_template_directory() . '/inc/tgm-plugin/tgm-hook.php';

if ( class_exists( 'CatchThemesDemoImportPlugin' ) ) {
    /**
    * OCDI plugin demo importer compatibility.
    */
    require get_template_directory() . '/inc/demo-import.php';
}
