<?php
/**
 * Business Park customizer active callbacks
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */


if ( ! function_exists( 'business_park_is_slider_active' ) ) :
	/**
	 * Check if slider is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_slider_active( $control ) {
		if ( 'disabled' != $control->manager->get_setting( 'business_park_theme_options[slider_enable]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_slider_content_type_active' ) ) :
	/**
	 * Check if slider any content type except demo is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_slider_content_type_active( $control ) {
		if ( business_park_is_slider_active( $control ) && 'demo' != $control->manager->get_setting( 'business_park_theme_options[slider_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_slider_page_content_active' ) ) :
	/**
	 * Check if slider content type page is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_slider_page_content_active( $control ) {
		if ( business_park_is_slider_active( $control ) && 'page' == $control->manager->get_setting( 'business_park_theme_options[slider_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_slider_post_content_active' ) ) :
	/**
	 * Check if slider content type post is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_slider_post_content_active( $control ) {
		if ( business_park_is_slider_active( $control ) && 'post' == $control->manager->get_setting( 'business_park_theme_options[slider_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_slider_custom_content_active' ) ) :
	/**
	 * Check if slider content type custom is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_slider_custom_content_active( $control ) {
		if ( business_park_is_slider_active( $control ) && 'custom' == $control->manager->get_setting( 'business_park_theme_options[slider_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_about_active' ) ) :
	/**
	 * Check if about is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_about_active( $control ) {
		if ( 'disabled' != $control->manager->get_setting( 'business_park_theme_options[about_enable]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_about_page_content_active' ) ) :
	/**
	 * Check if about content type page is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_about_page_content_active( $control ) {
		if ( business_park_is_about_active( $control ) && 'page' == $control->manager->get_setting( 'business_park_theme_options[about_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_about_post_content_active' ) ) :
	/**
	 * Check if about content type post is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_about_post_content_active( $control ) {
		if ( business_park_is_about_active( $control ) && 'post' == $control->manager->get_setting( 'business_park_theme_options[about_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_about_custom_content_active' ) ) :
	/**
	 * Check if about content type custom is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_about_custom_content_active( $control ) {
		if ( business_park_is_about_active( $control ) && 'custom' == $control->manager->get_setting( 'business_park_theme_options[about_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_testimonial_active' ) ) :
	/**
	 * Check if testimonial is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_testimonial_active( $control ) {
		if ( 'disabled' != $control->manager->get_setting( 'business_park_theme_options[testimonial_enable]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_testimonial_bg_image_active' ) ) :
	/**
	 * Check if testimonial backgroud image is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_testimonial_bg_image_active( $control ) {
		if ( business_park_is_testimonial_active( $control ) && 'image' == $control->manager->get_setting( 'business_park_theme_options[testimonial_background_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_testimonial_bg_video_active' ) ) :
	/**
	 * Check if testimonial backgroud image is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_testimonial_bg_video_active( $control ) {
		if ( business_park_is_testimonial_active( $control ) && 'video' == $control->manager->get_setting( 'business_park_theme_options[testimonial_background_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_testimonial_content_active' ) ) :
	/**
	 * Check if testimonial content type jetpack-testionial is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_testimonial_content_active( $control ) {
		if ( business_park_is_testimonial_active( $control ) && 'testimonial' == $control->manager->get_setting( 'business_park_theme_options[testimonial_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_testimonial_content_demo_inactive' ) ) :
	/**
	 * Check if testimonial content type demo is inactive.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_testimonial_content_demo_inactive( $control ) {
		if ( business_park_is_testimonial_active( $control ) && 'demo' != $control->manager->get_setting( 'business_park_theme_options[testimonial_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_testimonial_content_cat_active' ) ) :
	/**
	 * Check if testimonial content type category is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_testimonial_content_cat_active( $control ) {
		if ( business_park_is_testimonial_active( $control ) && 'category' == $control->manager->get_setting( 'business_park_theme_options[testimonial_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_portfolio_active' ) ) :
	/**
	 * Check if portfolio is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_portfolio_active( $control ) {
		if ( 'disabled' != $control->manager->get_setting( 'business_park_theme_options[portfolio_enable]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_portfolio_content_active' ) ) :
	/**
	 * Check if about content type page is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_portfolio_category_active( $control ) {
		if ( business_park_is_portfolio_active( $control ) && 'portfolio-category' == $control->manager->get_setting( 'business_park_theme_options[portfolio_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_portfolio_content_cat_active' ) ) :
	/**
	 * Check if portfolio content type category is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_portfolio_content_cat_active( $control ) {
		if ( business_park_is_portfolio_active( $control ) && 'category' == $control->manager->get_setting( 'business_park_theme_options[portfolio_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_portfolio_content_demo_inactive' ) ) :
	/**
	 * Check if portfolio content type demo is inactive.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_portfolio_content_demo_inactive( $control ) {
		if ( business_park_is_portfolio_active( $control ) && 'demo' != $control->manager->get_setting( 'business_park_theme_options[portfolio_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_logo_slider_active' ) ) :
	/**
	 * Check if logo slider is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_logo_slider_active( $control ) {
		if ( 'disabled' != $control->manager->get_setting( 'business_park_theme_options[logo_slider_enable]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_logo_slider_custom_active' ) ) :
	/**
	 * Check if custom content type page is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_logo_slider_custom_active( $control ) {
		if ( business_park_is_logo_slider_active( $control ) && 'custom' == $control->manager->get_setting( 'business_park_theme_options[logo_slider_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_logo_slider_content_demo_inactive' ) ) :
	/**
	 * Check if logo slider content type demo is inactive.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_logo_slider_content_demo_inactive( $control ) {
		if ( business_park_is_logo_slider_active( $control ) && 'demo' != $control->manager->get_setting( 'business_park_theme_options[logo_slider_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_service_active' ) ) :
	/**
	 * Check if service is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_service_active( $control ) {
		if ( 'disabled' != $control->manager->get_setting( 'business_park_theme_options[service_enable]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_service_content_demo_inactive' ) ) :
	/**
	 * Check if service content type demo is inactive.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_service_content_demo_inactive( $control ) {
		if ( business_park_is_service_active( $control ) && 'demo' != $control->manager->get_setting( 'business_park_theme_options[service_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_service_post_content_active' ) ) :
	/**
	 * Check if service content type post is active
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_service_post_content_active( $control ) {
		if ( business_park_is_service_active( $control ) && 'post' == $control->manager->get_setting( 'business_park_theme_options[service_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_service_page_content_active' ) ) :
	/**
	 * Check if service content type page is active
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_service_page_content_active( $control ) {
		if ( business_park_is_service_active( $control ) && 'page' == $control->manager->get_setting( 'business_park_theme_options[service_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_pie_chart_active' ) ) :
	/**
	 * Check if pie chart is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_pie_chart_active( $control ) {
		if ( 'disabled' != $control->manager->get_setting( 'business_park_theme_options[pie_chart_enable]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_pie_chart_content_demo_inactive' ) ) :
	/**
	 * Check if pie chart content type demo is inactive.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_pie_chart_content_demo_inactive( $control ) {
		if ( business_park_is_pie_chart_active( $control ) && 'demo' != $control->manager->get_setting( 'business_park_theme_options[pie_char_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_pricing_active' ) ) :
	/**
	 * Check if pricing is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_pricing_active( $control ) {
		if ( 'disabled' != $control->manager->get_setting( 'business_park_theme_options[pricing_enable]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_pricing_content_demo_inactive' ) ) :
	/**
	 * Check if pricing conent type demo is inactive.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_pricing_content_demo_inactive( $control ) {
		if ( business_park_is_pricing_active( $control ) && 'demo' != $control->manager->get_setting( 'business_park_theme_options[pricing_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_pricing_content_post_active' ) ) :
	/**
	 * Check if pricing conent type post is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_pricing_content_post_active( $control ) {
		if (  business_park_is_pricing_active( $control ) && 'post' == $control->manager->get_setting( 'business_park_theme_options[pricing_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_blog_section_active' ) ) :
	/**
	 * Check if blog is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_blog_section_active( $control ) {
		if ( 'disabled' != $control->manager->get_setting( 'business_park_theme_options[blog_enable]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_blog_content_demo_inactive' ) ) :
	/**
	 * Check if demo is inactive.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_blog_content_demo_inactive( $control ) {
		if ( 'demo' != $control->manager->get_setting( 'business_park_theme_options[blog_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_blog_content_cat_active' ) ) :
	/**
	 * Check if blog content type category is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_blog_content_cat_active( $control ) {
		if ( business_park_is_blog_section_active( $control ) && 'category' == $control->manager->get_setting( 'business_park_theme_options[blog_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_blog_content_post_active' ) ) :
	/**
	 * Check if blog content type post is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_blog_content_post_active( $control ) {
		if ( business_park_is_blog_section_active( $control ) && 'post' == $control->manager->get_setting( 'business_park_theme_options[blog_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_features_active' ) ) :
	/**
	 * Check if features is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_features_active( $control ) {
		if ( 'disabled' != $control->manager->get_setting( 'business_park_theme_options[features_enable]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_features_content_demo_inactive' ) ) :
	/**
	 * Check if features demo is inactive.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_features_content_demo_inactive( $control ) {
		if ( business_park_is_features_active( $control ) && 'demo' != $control->manager->get_setting( 'business_park_theme_options[features_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_contact_active' ) ) :
	/**
	 * Check if features is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_contact_active( $control ) {
		if ( 'disabled' != $control->manager->get_setting( 'business_park_theme_options[contact_enable]' )->value() )
			return true;

		return false;
	}
endif;

if ( ! function_exists( 'business_park_is_map_active' ) ) :
	/**
	 * Check if map is active.
	 *
	 * @since 0.1
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_map_active( $control ) {
		if ( 'disabled' != $control->manager->get_setting( 'business_park_theme_options[map_enable]' )->value() )
			return true;

		return false;
	}
endif;

if ( ! function_exists( 'business_park_is_footer_logo_enable' ) ) :
	/**
	 * Check if footer logo is enable.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_footer_logo_enable( $control ) {
		return $control->manager->get_setting( 'business_park_theme_options[footer_logo_enable]' )->value();
	}
endif;


if ( ! function_exists( 'business_park_is_pagination_enable' ) ) :
	/**
	 * Check if pagination is enabled.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_pagination_enable( $control ) {
		return $control->manager->get_setting( 'business_park_theme_options[enable_pagination]' )->value();
	}
endif;


if ( ! function_exists( 'business_park_is_loader_enable' ) ) :
	/**
	 * Check if loader is enabled.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_loader_enable( $control ) {
		return $control->manager->get_setting( 'business_park_theme_options[loader_enable]' )->value();
	}
endif;


if ( ! function_exists( 'business_park_is_loader_type_image' ) ) :
	/**
	 * Check if loader type image is enabled.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_loader_type_image( $control ) {
		if ( business_park_is_loader_enable( $control ) && 'image-gif' == $control->manager->get_setting( 'business_park_theme_options[loader_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_loader_type_icon' ) ) :
	/**
	 * Check if loader type image is enabled.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_loader_type_icon( $control ) {
		if ( business_park_is_loader_enable( $control ) && 'icon' == $control->manager->get_setting( 'business_park_theme_options[loader_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_team_active' ) ) :
	/**
	 * Check if team section is enabled.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_team_active( $control ) {
		if ( 'disabled' != $control->manager->get_setting( 'business_park_theme_options[team_enable]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_team_content_type_active' ) ) :
	/**
	 * Check if team any content type except demo is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_team_content_type_active( $control ) {
		if ( business_park_is_team_active( $control ) && 'demo' != $control->manager->get_setting( 'business_park_theme_options[team_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_team_post_content_active' ) ) :
	/**
	 * Check if team post content type except demo is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_team_post_content_active( $control ) {
		if ( business_park_is_team_active( $control ) && 'post' == $control->manager->get_setting( 'business_park_theme_options[team_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_team_page_content_active' ) ) :
	/**
	 * Check if team page content type except demo is active.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_team_page_content_active( $control ) {
		if ( business_park_is_team_active( $control ) && 'page' == $control->manager->get_setting( 'business_park_theme_options[team_content_type]' )->value() )
			return true;

		return false;
	}
endif;


if ( ! function_exists( 'business_park_is_team_demo_content_inactive' ) ) :
	/**
	 * Check if team demo content type inactive.
	 *
	 * @since Business Park Pro 2.0.0
	 *
	 * @param WP_Customize_Control $control WP_Customize_Control instance.
	 *
	 * @return bool Whether the control is active to the current preview.
	 */
	function business_park_is_team_demo_content_inactive( $control ) {
		if ( business_park_is_team_active( $control ) && 'demo' != $control->manager->get_setting( 'business_park_theme_options[team_content_type]' )->value() )
			return true;

		return false;
	}
endif;