<?php
/**
 * Business Park Theme Customizer
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */


/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function business_park_customize_register( $wp_customize ) {
	$options = business_park_get_theme_options();

	// Load customizer sanitization functions.
	require get_template_directory() . '/inc/customizer/sanitize.php';

	// Load customize active callback functions.
	require get_template_directory() . '/inc/customizer/active-callbacks.php';

	// Load customize partial functions.
	require get_template_directory() . '/inc/customizer/partial.php';

	// Load custom controls.
	require get_template_directory() . '/inc/customizer/custom-controls.php';

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	$wp_customize->get_control( 'custom_logo' )->description = esc_html__( 'The recommended size for the logo is 120px by 70px.', 'business-park-pro' );

	// Load color layout options.
	require get_template_directory() . '/inc/customizer/sections/color.php';

	// Load additonal menu options.
	require get_template_directory() . '/inc/customizer/sections/menu.php';

	/**
	* Theme Options for sections
	*/
	// Add panel for different sections
	$wp_customize->add_panel( 'business_park_sections_panel' , array(
	    'title'      => esc_html__( 'Sections','business-park-pro' ),
	    'description'=> esc_html__( 'Business Park available sections.', 'business-park-pro' ),
	    'priority'   => 130,
	) );

	// Load slider options.
	require get_template_directory() . '/inc/customizer/sections/top-bar.php';

	// Load slider options.
	require get_template_directory() . '/inc/customizer/sections/slider.php';

	// Load about us section options.
	require get_template_directory() . '/inc/customizer/sections/about.php';

	// Load testimonial section options.
	require get_template_directory() . '/inc/customizer/sections/testimonial.php';

	// Load portfolio section options.
	require get_template_directory() . '/inc/customizer/sections/portfolio.php';

	// Load logo slider section options.
	require get_template_directory() . '/inc/customizer/sections/logo-slider.php';

	// Load logo slider section options.
	require get_template_directory() . '/inc/customizer/sections/services.php';

	// Load pie chart section options.
	require get_template_directory() . '/inc/customizer/sections/pie-chart.php';

	// Load pricing section options.
	require get_template_directory() . '/inc/customizer/sections/pricing.php';

	// Load blog section options.
	require get_template_directory() . '/inc/customizer/sections/blog.php';

	// Load features options.
	require get_template_directory() . '/inc/customizer/sections/features.php';

	// Load team section options.
	require get_template_directory() . '/inc/customizer/sections/team.php';

	// Load contact options.
	require get_template_directory() . '/inc/customizer/sections/contact.php';

	// Load map options.
	require get_template_directory() . '/inc/customizer/sections/map.php';

	/**
	* Common Options
	*/
	// Add panel for common options
	$wp_customize->add_panel( 'business_park_theme_options_panel' , array(
	    'title'      => esc_html__( 'Theme Options','business-park-pro' ),
	    'description'=> esc_html__( 'Business Park Theme Options.', 'business-park-pro' ),
	    'priority'   => 150,
	) );

	if ( version_compare( $GLOBALS['wp_version'], '4.7', '<' ) ) {
		// Load custom-css options.
		require get_template_directory() . '/inc/customizer/theme-options/custom-css.php';
	}

	// Load breadcrumb options.
	require get_template_directory() . '/inc/customizer/theme-options/breadcrumb.php';

	// Load excerpt options.
	require get_template_directory() . '/inc/customizer/theme-options/excerpt.php';

	// Load footer options.
	require get_template_directory() . '/inc/customizer/theme-options/footer.php';

	// Load pagination options.
	require get_template_directory() . '/inc/customizer/theme-options/pagination.php';

	// Load layout options.
	require get_template_directory() . '/inc/customizer/theme-options/layout.php';

	// Load loader options.
	require get_template_directory() . '/inc/customizer/theme-options/loader.php';

	// Load homepage-static options.
	require get_template_directory() . '/inc/customizer/theme-options/homepage-static.php';

	// Load blog options .
	require get_template_directory() . '/inc/customizer/theme-options/blog-options.php';

	/**
	* Reset section
	*/
	// Add reset enable section
	$wp_customize->add_section( 'business_park_reset_section', array(
		'title'             => esc_html__( 'Reset all settings','business-park-pro' ),
		'description'       => esc_html__( 'Caution: All settings will be reset to default. Refresh the page after clicking Save & Publish.', 'business-park-pro' ),
	) );

	// Add reset enable setting and control.
	$wp_customize->add_setting( 'business_park_theme_options[reset_options]', array(
		'default'           => $options['reset_options'],
		'sanitize_callback' => 'business_park_sanitize_checkbox',
		'transport'            => 'postMessage', // Options: refresh or postMessage.
	) );

	$wp_customize->add_control( 'business_park_theme_options[reset_options]', array(
		'label'             => esc_html__( 'Check to reset all settings', 'business-park-pro' ),
		'section'           => 'business_park_reset_section',
		'type'              => 'checkbox',
	) );
}
add_action( 'customize_register', 'business_park_customize_register' );


/**
 * Enqueue styles on customizer preview.
 */
function business_park_customizer_styles() {
	if ( is_customize_preview() ) {
	   // Add fontawesome
		wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/assets/plugins/fontawesome/css/font-awesome.min.css', '', '4.6.3' );

		// Add custom css for customizer
		wp_enqueue_style( 'business-park-pro-customizer', get_template_directory_uri() . '/assets/css/customizer.min.css' );
	}
}
add_action( 'customize_controls_print_styles', 'business_park_customizer_styles' );


/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function business_park_customize_preview_js() {
	wp_enqueue_script( 'business_park_customizer', get_template_directory_uri() . '/assets/js/customizer.min.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'business_park_customize_preview_js' );


function business_park_inline_css() {
	$options              = business_park_get_theme_options();

	$testimonial_bg_image = '';
	if ( 'image' == $options['testimonial_background_type'] ) {
		$testimonial_bg_image = $options['testimonial_bg_image'];
	}

	$logo_slider_bg_image = $options['logo_slider_bg_image'];

	$pricing_bg_image         = $options['pricing_bg_image'];

	$social_menu_bg_color     = $options['social_menu_bg_color'];

	$portfolio_padding     = $options['portfolio_padding'];

	// Declare variable to store custom css
	$business_park_custom_css = '';
	$css = '';
	// Check if the custom CSS feature of 4.7 exists
	if ( function_exists( 'wp_update_custom_css_post' ) ) {
	    // Migrate any existing theme CSS to the core option added in WordPress 4.7.
	    if ( ! empty( $options['custom_css'] ) ) {
	    	$css = $options['custom_css'];
	    }

	    if ( $css ) {
	        $core_css = wp_get_custom_css(); // Preserve any CSS already added to the core option.
	        $return = wp_update_custom_css_post( $core_css . $css );

	        if ( ! is_wp_error( $return ) ) {
	            // Remove the old theme_mod, so that the CSS is stored in only one place moving forward.
	   			$options['custom_css'] = '';
				set_theme_mod( 'business_park_theme_options', $options );
	        }
	    }
	} else {
	    // Back-compat for WordPress < 4.7.
		if ( isset( $options['custom_css'] ) ) {
			$business_park_custom_css = $options['custom_css'];
		}
	}

	$team_bg_image            = $options['team_bg_image'];

	$animated_layout    = $options['site_animation'];
	$business_park_animation_css = '';
	if ( $animated_layout != true ){
		$business_park_animation_css .= '.os-animation { opacity: 1; }';
	}

	$css = '
		/* Testimonial background image */
		#client-carousel {
		    background-image: url("'.esc_url( $testimonial_bg_image ).'");
		}
		/* Logo slider background image */
		#logo-carousel {
		    background-image: url("'.esc_url( $logo_slider_bg_image ).'");
		}

		/* Pricing background image */
		#pricing {
		    background-image: url("'.esc_url( $pricing_bg_image ).'");
		}

		/* Top bar background color */
		.top-bar {
			background-color: '.esc_attr( $social_menu_bg_color ).';
		}

		/* Team background image */
		#team {
		    background-image: url("'.esc_url( $team_bg_image ).'");
		}

		/* Portfolio padding */
		.spacing-on .portfolio-item {
		    padding: '.esc_attr( $portfolio_padding ).'px;
		}
	'
	. $business_park_custom_css
	. $business_park_animation_css;

	wp_add_inline_style( 'business-park-pro-style', $css );
}
add_action( 'wp_enqueue_scripts', 'business_park_inline_css', 10 );
