<?php
/**
 * Business Park customizer default options
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */


/**
 * Returns the default options for business-park-pro.
 *
 * @since Business Park Pro 2.0.0
 * @return array An array of default values
 */
function business_park_get_default_theme_options() {
	$business_park_default_options = array(
		//Menu options
		'primary_menu_type'          => 'simple',
		'primary_menu_position'      => 'below-slider',
		'primary_menu_sticky_enable' => true,
		'primary_menu_search_icon'	  => true,

		//Default color layout
		'color_layout_options'		  => 'default',
		'site_animation'		  	  => true,
		'make_rounded_design'		  => false,

		/**
		* Section Options
		*/
		//Top bar options
		'top_bar_phone'         => '+123 456 789',
		'top_bar_email'         => 'info@themepalace.com',
		'top_bar_location'      => esc_html__( 'Jawalakhel, Lalitpur', 'business-park-pro' ),

		//Slider options
		'slider_enable'         => 'static-frontpage',
		'slider_content_type'   => 'demo',
		'slider_content_effect' => 'fadeout',
		'slider_content_speed'  => 500,
		'slider_content_page_count'  => 1,
		'enable_slider_captions'     => true,
		'enable_arrow_controls'      => true,
		'enable_slider_pager'        => true,
		'enable_slider_progress_bar' => true,
		'slider_content_read_more_text' => esc_html__( 'Read More', 'business-park-pro' ),

		//About options
		'about_enable'             => 'static-frontpage',
		'about_content_type'       => 'demo',

		//Testimonial ptions
		'testimonial_background_type' => 'image',
		'testimonial_enable'       => 'static-frontpage',
		'testimonial_content_type' => 'demo',
		'testimonial_title'        => esc_html__( 'What our clients are saying', 'business-park-pro' ),
		'testimonial_bg_image'     => get_template_directory_uri() . '/assets/images/parallax_01.jpg',
		'testimonial_content_count'=> 1,
		'testimonial_caption'=> false,

		//Portfolio options
		'portfolio_title'          => esc_html__( 'Our Work', 'business-park-pro' ),
		'portfolio_enable'         => 'static-frontpage',
		'portfolio_content_type'   => 'demo',
		'portfolio_padding'  		=>  0,

		//Logo slider options
		'logo_slider_enable'       => 'static-frontpage',
		'logo_slider_content_type' => 'demo',
		'logo_slider_bg_image'     => get_template_directory_uri() . '/assets/images/parallax_01.jpg',
		'logo_slider_content_count' => 1,

		//Team options
		'team_enable'       => 'static-frontpage',
		'team_content_type' => 'demo',
		'team_content_count' => 4,
		'team_section_title' => esc_html__( 'Meet Our Team', 'business-park-pro' ),
		'team_bg_image'		=> get_template_directory_uri() . '/assets/images/parallax_02.jpg',

		//Logo slider options
		'service_enable'       		=> 'static-frontpage',
		'service_section_title'		=> esc_html__( 'our services', 'business-park-pro' ),
		'service_content_type'		=> 'demo',
		'service_content_count'		=> 3,

		//Pie Chart options
		'pie_chart_enable'         => 'static-frontpage',
		'pie_chart_section_title'  => esc_html__( 'What we can do <span class="color-green">for  you', 'business-park-pro' ),
		'pie_char_content_type'    => 'demo',
		'pie_chart_content_count'  => 1,

		//Pricing options
		'pricing_enable'           => 'static-frontpage',
		'pricing_section_title'    => esc_html__( 'Our Pricing Packages', 'business-park-pro' ),
		'pricing_bg_image'         => get_template_directory_uri() . '/assets/images/parallax_02.jpg',
		'pricing_count'				=> 1,
		'pricing_content_type'		=> 'demo',

		//Pricing options
		'blog_enable'              => 'static-frontpage',
		'blog_title'               => esc_html__( 'Blog Posts', 'business-park-pro' ),
		'blog_count'					=> 3,
		'blog_content_type'			=> 'demo',

		//Features options
		'features_enable'          => 'static-frontpage',
		'features_section_title'   => esc_html__( 'Some Features', 'business-park-pro' ),
		'features_count'				=> 4,
		'features_bg'				=> false,
		'features_content_type'		=> 'demo',

		//Contact options
		'contact_enable'           => 'static-frontpage',
		'contact_section_title'    => sprintf ( esc_html__( 'Get in touch %1$s with us %2$s', 'business-park-pro' ), '<span class="color-green">', '</span>'),

		//Map options
		'map_enable'           => 'static-frontpage',

		/**
		* Theme Options
		*/
		'excerpt_length'           => 15,
		'footer_logo_enable'       => true,
		'footer_logo'              => get_template_directory_uri() . '/assets/images/footer-logo-green.png',
		'copyright_text'           => sprintf( esc_html__( 'Copyright &copy; %1s. All Rights Reserved.', 'business-park-pro' ),  date( 'Y' ) ),
		'powered_by_text'		   => sprintf( esc_html__( 'Proudly powered by %1$s WordPress %2$s | %3$s
		Business Park Pro %4$s by %4$s Theme Palace %5$s', 'business-park-pro' ), '<a href="https://wordpress.org/">', '</a>', '<a target="_blank" href="http://themepalace.com/downloads/business-park-pro/">', '</a>', '<a target="_blank" href="http://themepalace.com/">', '</a>' ),
		'enable_pagination'        => true,
		'pagination_type'          => 'numeric',
		'archive_content_type'     => 'excerpt',
		'social_menu_bg_color'     => '#BFBFBF',
		'sidebar_position'         => 'right-sidebar',
		'site_layout'         		=> 'wide',
		'loader_enable'         	=> true,
		'loader_type'         		=> 'image-gif',
		'loader_gif'         		=> get_template_directory_uri() . '/assets/images/loader-icon.gif',
		'reset_options'      		=> false,
		'enable_frontpage_content' => true,
		// Breadcrumb
		'breadcumb_option'			=> false,
		'breadcumb_onhomepage'		=> false,
		'breadcumb_seperator'		=> '>>',
		'hide_date'					=> false,
		'hide_author'				=> false,
		'hide_category'				=> false,
		'hide_tags'					=> false,
	);

	$output = apply_filters( 'business_park_default_theme_options', $business_park_default_options );
	// Sort array in ascending order, according to the key:
	if ( ! empty( $output ) ) {
		ksort( $output );
	}

	return $output;
}