<?php
/**
 * About Customizer options
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */

// Add about enable section
$wp_customize->add_section( 'business_park_about_section', array(
	'title'             => esc_html__( 'About','business-park-pro' ),
	'description'       => esc_html__( 'About section options.', 'business-park-pro' ),
	'panel'             => 'business_park_sections_panel'
) );

// Add about enable setting and control.
$wp_customize->add_setting( 'business_park_theme_options[about_enable]', array(
	'default'           => $options['about_enable'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[about_enable]', array(
	'label'             => esc_html__( 'Enable on', 'business-park-pro' ),
	'section'           => 'business_park_about_section',
	'type'              => 'select',
	'choices'           => business_park_enable_options()
) );

// Add about content type setting and control.
$wp_customize->add_setting( 'business_park_theme_options[about_content_type]', array(
	'default'           => $options['about_content_type'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[about_content_type]', array(
	'label'           => esc_html__( 'Content Type', 'business-park-pro' ),
	'section'         => 'business_park_about_section',
	'type'            => 'select',
	'active_callback' => 'business_park_is_about_active',
	'choices'         => business_park_content_type(),
) );

// Show page drop-down setting and control
$wp_customize->add_setting( 'business_park_theme_options[about_content_page]', array(
	'sanitize_callback' => 'business_park_sanitize_page'
) );

$wp_customize->add_control( 'business_park_theme_options[about_content_page]', array(
	'label'           => esc_html__( 'Page', 'business-park-pro' ),
	'description'     => esc_html__( 'The recommended size for the featured image while using it for this section is 500px by 250px.', 'business-park-pro' ),
	'section'         => 'business_park_about_section',
	'active_callback' => 'business_park_is_about_page_content_active',
	'type'            => 'dropdown-pages'
) );

// Show post type setting and control
$wp_customize->add_setting( 'business_park_theme_options[about_content_post]', array(
	'sanitize_callback' => 'business_park_sanitize_number_range'
) );

$wp_customize->add_control( 'business_park_theme_options[about_content_post]', array(
	'label'           => esc_html__( 'Post ID', 'business-park-pro' ),
	'description'     => esc_html__( 'Enter the Post ID here.', 'business-park-pro' ),
	'section'         => 'business_park_about_section',
	'active_callback' => 'business_park_is_about_post_content_active',
	'type'            => 'number',
	'input_attrs'     => array(
		'min'	=> 0
		)
) );

/**
 * Custom content type
 */
// Show custom title setting and control
$wp_customize->add_setting( 'business_park_theme_options[about_content_custom_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'transport'			  => 'postMessage'
) );

$wp_customize->add_control( 'business_park_theme_options[about_content_custom_title]', array(
	'label'           => esc_html__( 'Title', 'business-park-pro' ),
	'section'         => 'business_park_about_section',
	'active_callback' => 'business_park_is_about_custom_content_active',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial( 'business_park_theme_options[about_content_custom_title]', array(
		'selector'            => '#about h2.entry-title',
		'render_callback'     => 'business_park_customize_about_content_custom_title',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
	) );
}

// Show custom content setting and control
$wp_customize->add_setting( 'business_park_theme_options[about_content_custom_content]', array(
	'sanitize_callback' => 'esc_textarea',
	'transport'			  => 'postMessage'
) );

$wp_customize->add_control( 'business_park_theme_options[about_content_custom_content]', array(
	'label'           => esc_html__( 'Content', 'business-park-pro' ),
	'section'         => 'business_park_about_section',
	'active_callback' => 'business_park_is_about_custom_content_active',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial( 'business_park_theme_options[about_content_custom_content]', array(
		'selector'            => '#about .entry-content .description',
		'render_callback'     => 'business_park_customize_about_content_custom_content',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
	) );
}

// Show custom image setting and control
$wp_customize->add_setting( 'business_park_theme_options[about_content_custom_image]', array(
	'sanitize_callback' => 'business_park_sanitize_image',
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'business_park_theme_options[about_content_custom_image]',
	array(
		'label'           => esc_html__( 'Image', 'business-park-pro' ),
		'description'     => esc_html__( 'The recommended size for the image is 500px by 250px.', 'business-park-pro' ),
		'section'         => 'business_park_about_section',
		'active_callback' => 'business_park_is_about_custom_content_active',
) ) );

// Show custom title setting and control
$wp_customize->add_setting( 'business_park_theme_options[about_content_custom_image_url]', array(
	'sanitize_callback' => 'esc_url_raw'
) );

$wp_customize->add_control( 'business_park_theme_options[about_content_custom_image_url]', array(
	'label'           => esc_html__( 'URL', 'business-park-pro' ),
	'section'         => 'business_park_about_section',
	'active_callback' => 'business_park_is_about_custom_content_active',
	'type'				=> 'url',
) );



