<?php
/**
 * Blog Customizer options
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */


// Add blog enable section
$wp_customize->add_section( 'business_park_blog_section', array(
	'title'             => esc_html__( 'Blog','business-park-pro' ),
	'description'       => esc_html__( 'Blog section options.', 'business-park-pro' ),
	'panel'             => 'business_park_sections_panel'
) );

// Add blog enable setting and control.
$wp_customize->add_setting( 'business_park_theme_options[blog_enable]', array(
	'default'           => $options['blog_enable'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[blog_enable]', array(
	'label'             => esc_html__( 'Enable on', 'business-park-pro' ),
	'section'           => 'business_park_blog_section',
	'type'              => 'select',
	'choices'           => business_park_enable_options()
) );

// Add blog title setting and control.
$wp_customize->add_setting( 'business_park_theme_options[blog_title]', array(
	'default'           => $options['blog_title'],
	'transport'         => 'postMessage',
	'sanitize_callback' => 'sanitize_text_field'
) );

$wp_customize->add_control( 'business_park_theme_options[blog_title]', array(
	'label'           => esc_html__( 'Title', 'business-park-pro' ),
	'section'         => 'business_park_blog_section',
	'type'            => 'text',
	'active_callback' => 'business_park_is_blog_section_active',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial( 'business_park_theme_options[blog_title]', array(
		'selector'            => '#blog-section h2.entry-title',
		'render_callback'     => 'business_park_customize_partial_blog_title',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
	) );
}

// Add blog content type setting and control.
$wp_customize->add_setting( 'business_park_theme_options[blog_content_type]', array(
	'default'           => $options['blog_content_type'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[blog_content_type]', array(
	'label'           => esc_html__( 'Content Type', 'business-park-pro' ),
	'section'         => 'business_park_blog_section',
	'type'            => 'select',
	'active_callback' => 'business_park_is_blog_section_active',
	'choices'         => business_park_blog_content_type()
) );

// Add blog number setting and control.
$wp_customize->add_setting( 'business_park_theme_options[blog_count]', array(
	'default'           => $options['blog_count'],
	'sanitize_callback' => 'business_park_sanitize_number_range'
) );

$wp_customize->add_control( 'business_park_theme_options[blog_count]', array(
	'label'           => esc_html__( 'Number of posts.', 'business-park-pro' ),
	'description'     => esc_html__( 'Notice: Please refresh after the number of slides is set to see the effects.', 'business-park-pro' ),
	'section'         => 'business_park_blog_section',
	'type'            => 'number',
	'active_callback' => 'business_park_is_blog_content_demo_inactive',
	'input_attrs'     => array(
		'max' => 6,
		'min' => 1
	)
) );

/**
 * Content type: Catgory
*/
// Show category type setting and control
$wp_customize->add_setting( 'business_park_theme_options[blog_content_category]', array(
	'sanitize_callback' => 'absint'
) );

$wp_customize->add_control( new Business_Park_Dropdown_Taxonomies_Control( $wp_customize, 'business_park_theme_options[blog_content_category]', array(
	'label'           => esc_html__( 'Category', 'business-park-pro' ),
	'description'     => esc_html__( 'Select the category of posts to be shown.', 'business-park-pro' ),
	'section'         => 'business_park_blog_section',
	'active_callback' => 'business_park_is_blog_content_cat_active',
) ) );

/**
 * Content type: Post
*/
// Show post type setting and control
for ($i=1; $i <= $options['blog_count']; $i++) {
	# code...
	$wp_customize->add_setting( 'business_park_theme_options[blog_content_post_'.$i.']', array(
		'sanitize_callback' => 'business_park_sanitize_number_range'
	) );

	$wp_customize->add_control( 'business_park_theme_options[blog_content_post_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Post #%s', 'business-park-pro' ), $i ),
		'description'     => esc_html__( 'Enter the Post ID here.', 'business-park-pro' ),
		'section'         => 'business_park_blog_section',
		'active_callback' => 'business_park_is_blog_content_post_active',
		'type'				=> 'number',
		'input_attrs'     => array(
			'min'	=> 0
			)
	) );
}