<?php
/**
 * Contact Customizer options
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */


// Add about enable section
$wp_customize->add_section( 'business_park_contact_section', array(
	'title'             => esc_html__( 'Contact','business-park-pro' ),
	'description'       => esc_html__( 'Contact section options.', 'business-park-pro' ),
	'panel'             => 'business_park_sections_panel'
) );

// Add about enable setting and control.
$wp_customize->add_setting( 'business_park_theme_options[contact_enable]', array(
	'default'           => $options['contact_enable'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[contact_enable]', array(
	'label'             => esc_html__( 'Enable on', 'business-park-pro' ),
	'section'           => 'business_park_contact_section',
	'type'              => 'select',
	'choices'           => business_park_enable_options()
) );

// Show contact section title setting and control
$wp_customize->add_setting( 'business_park_theme_options[contact_section_title]', array(
	'sanitize_callback' => 'business_park_santize_allow_tag',
	'default'			  => $options['contact_section_title'],
	'transport'			  => 'postMessage'
) );

$wp_customize->add_control( 'business_park_theme_options[contact_section_title]', array(
	'label'           => esc_html__( 'Section Title', 'business-park-pro' ),
	'description'     => esc_html__( 'Only the HTML tag: span is allowed in this text field.', 'business-park-pro' ),
	'section'         => 'business_park_contact_section',
	'active_callback' => 'business_park_is_contact_active',
	'type'            => 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial( 'business_park_theme_options[contact_section_title]', array(
		'selector'            => '#contact-section h2.entry-title',
		'render_callback'     => 'business_park_customize_partial_contact_title',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
	) );
}

// Show contact section title setting and control
$wp_customize->add_setting( 'business_park_theme_options[contact_form_shortcode]', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'business_park_theme_options[contact_form_shortcode]', array(
	'label'           => esc_html__( 'Contact Form Shortcode', 'business-park-pro' ),
	'description'     => esc_html__( 'Input the shortcode generated by your contact form here.', 'business-park-pro' ),
	'section'         => 'business_park_contact_section',
	'active_callback' => 'business_park_is_contact_active',
	'type'            => 'textarea',
	'input_attrs'     => array(
		'placeholder' => '[contact-form-7 id="277" title="Contact form 1"]'
		)
) );
