<?php
/**
 * Features Customizer options
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */


// Add features enable section
$wp_customize->add_section( 'business_park_features_section', array(
	'title'             => esc_html__( 'Features','business-park-pro' ),
	'description'       => esc_html__( 'Features section options.', 'business-park-pro' ),
	'panel'             => 'business_park_sections_panel'
) );

// Add features enable setting and control.
$wp_customize->add_setting( 'business_park_theme_options[features_enable]', array(
	'default'           => $options['features_enable'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[features_enable]', array(
	'label'             => esc_html__( 'Enable on', 'business-park-pro' ),
	'section'           => 'business_park_features_section',
	'type'              => 'select',
	'choices'           => business_park_enable_options()
) );

// Show features section title setting and control
$wp_customize->add_setting( 'business_park_theme_options[features_section_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			  => $options['features_section_title'],
	'transport'			  => 'postMessage'
) );

$wp_customize->add_control( 'business_park_theme_options[features_section_title]', array(
	'label'           => esc_html__( 'Section Title', 'business-park-pro' ),
	'section'         => 'business_park_features_section',
	'active_callback' => 'business_park_is_features_active',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial( 'business_park_theme_options[features_section_title]', array(
		'selector'            => '#features h2.entry-title',
		'render_callback'     => 'business_park_customize_partial_features_title',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
	) );
}

// Add features background setting and control.
$wp_customize->add_setting( 'business_park_theme_options[features_bg]', array(
	'default'           => $options['features_bg'],
	'sanitize_callback' => 'business_park_sanitize_checkbox',
) );

$wp_customize->add_control( 'business_park_theme_options[features_bg]', array(
	'label'           => esc_html__( 'Enable background.', 'business-park-pro' ),
	'section'         => 'business_park_features_section',
	'active_callback' => 'business_park_is_features_active',
	'type'				=> 'checkbox',
) );

// Add features content type setting and control.
$wp_customize->add_setting( 'business_park_theme_options[features_content_type]', array(
	'default'           => $options['features_content_type'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[features_content_type]', array(
	'label'           => esc_html__( 'Content Type', 'business-park-pro' ),
	'section'         => 'business_park_features_section',
	'type'            => 'select',
	'active_callback' => 'business_park_is_features_active',
	'choices'         => business_park_logo_slider_content_type()
) );

// Add blog number setting and control.
$wp_customize->add_setting( 'business_park_theme_options[features_count]', array(
	'default'           => $options['features_count'],
	'sanitize_callback' => 'business_park_sanitize_number_range'
) );

$wp_customize->add_control( 'business_park_theme_options[features_count]', array(
	'label'           => esc_html__( 'Number of features.', 'business-park-pro' ),
	'description'     => esc_html__( 'Notice: Please refresh after the number of slides is set to see the effects.', 'business-park-pro' ),
	'section'         => 'business_park_features_section',
	'type'            => 'number',
	'active_callback' => 'business_park_is_features_content_demo_inactive',
	'input_attrs'     => array(
		'max' => 8,
		'min' => 1
	)
) );

for ( $i=1; $i <= $options['features_count']; $i++ ) {
	// Show features icon setting and control
	$wp_customize->add_setting( 'business_park_theme_options[features_icon_'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( 'business_park_theme_options[features_icon_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Icon #%s', 'business-park-pro' ), $i ),
		'section'         => 'business_park_features_section',
		'active_callback' => 'business_park_is_features_content_demo_inactive',
		'type'				=> 'text',
		'input_attrs'		=> array( 'placeholder'		=> 'fa-archive' )
	) );

	// Show features icon color setting and control
	$wp_customize->add_setting( 'business_park_theme_options[features_icon_color_'.$i.']', array(
		'sanitize_callback' => 'sanitize_hex_color'
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'business_park_theme_options[features_icon_color_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Icon Color #%s', 'business-park-pro' ), $i ),
		'section'         => 'business_park_features_section',
		'active_callback' => 'business_park_is_features_content_demo_inactive',
	) ) );

	// Show features name setting and control
	$wp_customize->add_setting( 'business_park_theme_options[features_name_'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( 'business_park_theme_options[features_name_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Name #%s', 'business-park-pro' ), $i ),
		'section'         => 'business_park_features_section',
		'active_callback' => 'business_park_is_features_content_demo_inactive',
		'type'				=> 'text',
	) );

	// Show features count setting and control
	$wp_customize->add_setting( 'business_park_theme_options[features_count_'.$i.']', array(
		'sanitize_callback' => 'business_park_sanitize_number_range'
	) );

	$wp_customize->add_control( 'business_park_theme_options[features_count_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Count #%s', 'business-park-pro' ), $i ),
		'section'         => 'business_park_features_section',
		'active_callback' => 'business_park_is_features_content_demo_inactive',
		'type'				=> 'number',
		'input_attrs'		=> array(
			'min' => 0
			)
	) );

	// Featues custom hr setting and control
	$wp_customize->add_setting( 'business_park_theme_options[features_content_custom_hr'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Business_Park_Customize_Horizontal_Line( $wp_customize, 'business_park_theme_options[features_content_custom_hr'.$i.']',
		array(
			'section'         => 'business_park_features_section',
			'active_callback' => 'business_park_is_features_content_demo_inactive',
			'type'				=> 'hr'
	) ) );
}