<?php
/**
 * Logo Slider Customizer options
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */

// Add logo slider enable section
$wp_customize->add_section( 'business_park_logo_slider_section', array(
	'title'             => esc_html__( 'Logo Slider','business-park-pro'),
	'description'       => esc_html__( 'Logo Slider section options.', 'business-park-pro' ),
	'panel'             => 'business_park_sections_panel'
) );

// Add logo slider enable setting and control.
$wp_customize->add_setting( 'business_park_theme_options[logo_slider_enable]', array(
	'default'           => $options['logo_slider_enable'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[logo_slider_enable]', array(
	'label'             => esc_html__( 'Enable on', 'business-park-pro' ),
	'section'           => 'business_park_logo_slider_section',
	'type'              => 'select',
	'choices'           => business_park_enable_options()
) );

// Add logo slider bg-image setting and control.
$wp_customize->add_setting( 'business_park_theme_options[logo_slider_bg_image]', array(
	'default'           => $options['logo_slider_bg_image'],
	'sanitize_callback' => 'business_park_sanitize_image',
) );

$wp_customize->add_control( new WP_Customize_Image_Control ( $wp_customize, 'business_park_theme_options[logo_slider_bg_image]', array(
	'label'           => esc_html__( 'Background Image', 'business-park-pro' ),
	'section'         => 'business_park_logo_slider_section',
	'active_callback' => 'business_park_is_logo_slider_active',
) ) );

// Add logo slider content type setting and control.
$wp_customize->add_setting( 'business_park_theme_options[logo_slider_content_type]', array(
	'default'           => $options['logo_slider_content_type'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[logo_slider_content_type]', array(
	'label'           => esc_html__( 'Content Type', 'business-park-pro' ),
	'section'         => 'business_park_logo_slider_section',
	'type'            => 'select',
	'active_callback' => 'business_park_is_logo_slider_active',
	'choices'         => business_park_logo_slider_content_type()
) );

// Add logo slider number setting and control.
$wp_customize->add_setting( 'business_park_theme_options[logo_slider_content_count]', array(
	'default'           => $options['logo_slider_content_count'],
	'sanitize_callback' => 'business_park_sanitize_number_range'
) );

$wp_customize->add_control( 'business_park_theme_options[logo_slider_content_count]', array(
	'label'           => esc_html__( 'Number of logos', 'business-park-pro' ),
	'description'     => esc_html__( 'Notice: Please refresh after the number of slides is set to see the effects.', 'business-park-pro' ),
	'section'         => 'business_park_logo_slider_section',
	'type'            => 'number',
	'active_callback' => 'business_park_is_logo_slider_content_demo_inactive',
	'input_attrs'     => array(
		'max' => 5,
		'min' => 1
	)
) );

for ( $i=1; $i <= $options['logo_slider_content_count']; $i++ ) {
	// Show logo upload setting and control
	$wp_customize->add_setting( 'business_park_theme_options[logo_slider_image_'.$i.']', array(
		'sanitize_callback' => 'business_park_sanitize_image'
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'business_park_theme_options[logo_slider_image_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Logo #%s', 'business-park-pro' ), $i ),
		'description'		=> esc_html__( 'The recommended size for the logo is 180px by 90px.', 'business-park-pro' ),
		'button_labels'   => array(
			'placeholder'     => esc_attr__( 'No logo selected', 'business-park-pro' ),
			'select'          => esc_html__( 'Select Logo', 'business-park-pro' ),
			'change'          => esc_html__( 'Change Logo', 'business-park-pro' ),
			'frame_title'     => esc_html__( 'Select Logo', 'business-park-pro' ),
			'frame_button'    => esc_html__( 'Choose Logo', 'business-park-pro' ),
		),
		'section'         => 'business_park_logo_slider_section',
		'active_callback' => 'business_park_is_logo_slider_custom_active',
	) ) );

	// Show logo link setting and control
	$wp_customize->add_setting( 'business_park_theme_options[logo_slider_image_url_'.$i.']', array(
		'sanitize_callback' => 'esc_url'
	) );

	$wp_customize->add_control( 'business_park_theme_options[logo_slider_image_url_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Logo URL #%s', 'business-park-pro' ), $i ),
		'section'         => 'business_park_logo_slider_section',
		'active_callback' => 'business_park_is_logo_slider_custom_active',
		'type'				=> 'url'
	) );

	// Show logo alt text setting and control
	$wp_customize->add_setting( 'business_park_theme_options[logo_slider_image_alt_'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( 'business_park_theme_options[logo_slider_image_alt_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Alt Text #%s', 'business-park-pro' ), $i ),
		'section'         => 'business_park_logo_slider_section',
		'active_callback' => 'business_park_is_logo_slider_custom_active',
		'type'				=> 'text'
	) );

	// Logo slider hr setting and control
	$wp_customize->add_setting( 'business_park_theme_options[logo_slider_content_hr_'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Business_Park_Customize_Horizontal_Line( $wp_customize, 'business_park_theme_options[logo_slider_content_hr_'.$i.']',
		array(
			'section'         => 'business_park_logo_slider_section',
			'active_callback' => 'business_park_is_logo_slider_custom_active',
			'type'				=> 'hr'
	) ) );
}