<?php
/**
 * Google Map Customizer options
 *
 * @package Theme Palace
 * @subpackage Business_Park
 * @since Business Park Pro 2.0.0
 */


// Add map enable section
$wp_customize->add_section( 'business_park_map_section', array(
	'title'             => esc_html__( 'Google Map','business-park-pro' ),
	'description'       => esc_html__( 'Google Map section options.', 'business-park-pro' ),
	'panel'             => 'business_park_sections_panel'
) );

// Add map enable setting and control.
$wp_customize->add_setting( 'business_park_theme_options[map_enable]', array(
	'default'           => $options['map_enable'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[map_enable]', array(
	'label'             => esc_html__( 'Enable on', 'business-park-pro' ),
	'section'           => 'business_park_map_section',
	'type'              => 'select',
	'choices'           => business_park_enable_options()
) );

// Show contact section title setting and control
$wp_customize->add_setting( 'business_park_theme_options[google_map_shortcode]', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'business_park_theme_options[google_map_shortcode]', array(
	'label'           => esc_html__( 'Map Shortcode', 'business-park-pro' ),
	'description'     => esc_html__( 'Input the shortcode generated by your contact form here.', 'business-park-pro' ),
	'section'         => 'business_park_map_section',
	'active_callback' => 'business_park_is_map_active',
	'type'            => 'textarea',
	'input_attrs'     => array(
		'placeholder' => esc_attr__( '[wpgmza id="1"]','business-park-pro' ),
		)
) );