<?php
/**
 * Menu Customizer options
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */


// Add about enable section
$wp_customize->add_section( 'business_park_additional_menu_options', array(
	'title'             => esc_html__( 'Additional Options','business-park-pro' ),
	'description'       => esc_html__( 'Additional menu options.', 'business-park-pro' ),
	'panel'             => 'nav_menus',
	'priority'          => 5
) );

// Social menu color setting and control.
$wp_customize->add_setting( 'business_park_theme_options[social_menu_bg_color]', array(
	'default'           => $options['social_menu_bg_color'],
	'sanitize_callback' => 'sanitize_hex_color',
) );

$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'business_park_theme_options[social_menu_bg_color]', array(
	'label'             => esc_html__( 'Top Bar Background Color', 'business-park-pro' ),
	'section'           => 'business_park_additional_menu_options',
) ) );

// Add primary menu sticky setting and control.
$wp_customize->add_setting( 'business_park_theme_options[primary_menu_sticky_enable]', array(
	'default'           => $options['primary_menu_sticky_enable'],
	'sanitize_callback' => 'business_park_sanitize_checkbox',
) );

$wp_customize->add_control( 'business_park_theme_options[primary_menu_sticky_enable]', array(
	'label'             => esc_html__( 'Make Primary Menu Sticky', 'business-park-pro' ),
	'section'           => 'business_park_additional_menu_options',
	'type'              => 'checkbox',
) );

// Add primary menu type setting and control.
$wp_customize->add_setting( 'business_park_theme_options[primary_menu_type]', array(
	'default'           => $options['primary_menu_type'],
	'sanitize_callback' => 'business_park_sanitize_select',
) );

$wp_customize->add_control( 'business_park_theme_options[primary_menu_type]', array(
	'label'             => esc_html__( 'Primary Menu Type', 'business-park-pro' ),
	'section'           => 'business_park_additional_menu_options',
	'type'              => 'select',
	'choices'           => business_park_primary_menu_type(),
) );

// Add primary menu position setting and control.
$wp_customize->add_setting( 'business_park_theme_options[primary_menu_position]', array(
	'default'           => $options['primary_menu_position'],
	'sanitize_callback' => 'business_park_sanitize_select',
) );

$wp_customize->add_control( 'business_park_theme_options[primary_menu_position]', array(
	'label'             => esc_html__( 'Primary Menu Position', 'business-park-pro' ),
	'description'             => esc_html__( 'Notice: Please refresh the page to see the change.', 'business-park-pro' ),
	'section'           => 'business_park_additional_menu_options',
	'type'              => 'select',
	'choices'           => business_park_primary_menu_position(),
) );

// Add search options setting and control.
$wp_customize->add_setting( 'business_park_theme_options[primary_menu_search_icon]', array(
	'default'           => $options['primary_menu_search_icon'],
	'sanitize_callback' => 'business_park_sanitize_checkbox',
) );

$wp_customize->add_control( 'business_park_theme_options[primary_menu_search_icon]', array(
	'label'             => esc_html__( 'Show Search Icon', 'business-park-pro' ),
	'section'           => 'business_park_additional_menu_options',
	'type'              => 'checkbox',
) );