<?php
/**
 * Pie Chart Customizer options
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */


// Add about enable section
$wp_customize->add_section( 'business_park_pie_chart_section', array(
	'title'             => esc_html__( 'Pie Chart','business-park-pro' ),
	'description'       => esc_html__( 'Pie Chart section options.', 'business-park-pro' ),
	'panel'             => 'business_park_sections_panel'
) );

// Add about enable setting and control.
$wp_customize->add_setting( 'business_park_theme_options[pie_chart_enable]', array(
	'default'           => $options['pie_chart_enable'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[pie_chart_enable]', array(
	'label'             => esc_html__( 'Enable on', 'business-park-pro' ),
	'section'           => 'business_park_pie_chart_section',
	'type'              => 'select',
	'choices'           => business_park_enable_options()
) );

// Show pie chart section title setting and control
$wp_customize->add_setting( 'business_park_theme_options[pie_chart_section_title]', array(
	'sanitize_callback' => 'business_park_santize_allow_tag',
	'default'			  => $options['pie_chart_section_title'],
	'transport'			  => 'postMessage'
) );

$wp_customize->add_control( 'business_park_theme_options[pie_chart_section_title]', array(
	'label'           => esc_html__( 'Section Title', 'business-park-pro' ),
	'description'           => esc_html__( 'Only the HTML tag: span is allowed in this text field.', 'business-park-pro' ),
	'section'         => 'business_park_pie_chart_section',
	'active_callback' => 'business_park_is_pie_chart_active',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial( 'business_park_theme_options[pie_chart_section_title]', array(
		'selector'            => '#pie-chart h2.entry-title',
		'render_callback'     => 'business_park_customize_partial_pie_chart_title',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
	) );
}

// Add pie chart content type setting and control.
$wp_customize->add_setting( 'business_park_theme_options[pie_char_content_type]', array(
	'default'           => $options['pie_char_content_type'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[pie_char_content_type]', array(
	'label'           => esc_html__( 'Content Type', 'business-park-pro' ),
	'section'         => 'business_park_pie_chart_section',
	'type'            => 'select',
	'active_callback' => 'business_park_is_pie_chart_active',
	'choices'         => business_park_logo_slider_content_type()
) );

// Add pie chart number setting and control.
$wp_customize->add_setting( 'business_park_theme_options[pie_chart_content_count]', array(
	'default'           => $options['pie_chart_content_count'],
	'sanitize_callback' => 'business_park_sanitize_number_range'
) );

$wp_customize->add_control( 'business_park_theme_options[pie_chart_content_count]', array(
	'label'           => esc_html__( 'Number of pie charts', 'business-park-pro' ),
	'description'     => esc_html__( 'Notice: Please refresh after the number of slides is set to see the effects.', 'business-park-pro' ),
	'section'         => 'business_park_pie_chart_section',
	'type'            => 'number',
	'active_callback' => 'business_park_is_pie_chart_content_demo_inactive',
	'input_attrs'     => array(
		'max' => 4,
		'min' => 1
	)
) );

for ( $i=1; $i <= $options['pie_chart_content_count']; $i++ ) {
	// Show chart setting and control
	$wp_customize->add_setting( 'business_park_theme_options[chart_title_'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( 'business_park_theme_options[chart_title_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Chart Title #%s', 'business-park-pro' ), $i ),
		'section'         => 'business_park_pie_chart_section',
		'active_callback' => 'business_park_is_pie_chart_content_demo_inactive',
		'type'				=> 'text'
	) );

	// Show chart setting and control
	$wp_customize->add_setting( 'business_park_theme_options[chart_value_'.$i.']', array(
		'sanitize_callback' => 'business_park_sanitize_number_range'
	) );

	$wp_customize->add_control( 'business_park_theme_options[chart_value_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Chart Value #%s', 'business-park-pro' ), $i ),
		'description'		=> esc_html__( 'Value should be in percentage which means between 1 and 100.', 'business-park-pro' ),
		'section'         => 'business_park_pie_chart_section',
		'active_callback' => 'business_park_is_pie_chart_content_demo_inactive',
		'type'				=> 'number',
		'input_attrs'       => array(
		    'style'          => 'width: 80px;',
		    'max'				=> 100,
		    'min'				=> 1,
		   ),
	) );

	// Slider custom hr setting and control
	$wp_customize->add_setting( 'business_park_theme_options[pie_chart_custom_hr'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Business_Park_Customize_Horizontal_Line( $wp_customize, 'business_park_theme_options[pie_chart_custom_hr'.$i.']',
		array(
			'section'         => 'business_park_pie_chart_section',
			'active_callback' => 'business_park_is_pie_chart_content_demo_inactive',
			'type'				=> 'hr'
	) ) );
}