<?php
/**
 * Portfolio Customizer options
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */

// Add portfolio enable section
$wp_customize->add_section( 'business_park_portfolio_section', array(
	'title'             => esc_html__( 'Portfolio','business-park-pro'),
	'description'       => sprintf( esc_html__( 'Porfolio Content Type Option requires %1$sJetPack%2$s Plugin with Custom Content Types module Enabled and checked at %3$sSettings ->Writing%4$s.', 'business-park-pro' ), '<a target="_blank" href="'.esc_url( 'https://wordpress.org/plugins/jetpack/' ).'">', '</a>', '<a target="_blank" href="'. esc_url( admin_url('options-writing.php') ).'">', '</a>' ),
	'panel'             => 'business_park_sections_panel'
) );

// Add portfolio enable setting and control.
$wp_customize->add_setting( 'business_park_theme_options[portfolio_enable]', array(
	'default'           => $options['portfolio_enable'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[portfolio_enable]', array(
	'label'             => esc_html__( 'Enable on', 'business-park-pro' ),
	'section'           => 'business_park_portfolio_section',
	'type'              => 'select',
	'choices'           => business_park_enable_options()
) );

// Add portfolio title setting and control.
$wp_customize->add_setting( 'business_park_theme_options[portfolio_title]', array(
	'default'           => $options['portfolio_title'],
	'transport'         => 'postMessage',
	'sanitize_callback' => 'sanitize_text_field'
) );

$wp_customize->add_control( 'business_park_theme_options[portfolio_title]', array(
	'label'           => esc_html__( 'Title', 'business-park-pro' ),
	'section'         => 'business_park_portfolio_section',
	'type'            => 'text',
	'active_callback' => 'business_park_is_portfolio_active',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial( 'business_park_theme_options[portfolio_title]', array(
		'selector'            => '#portfolio-gallery h2.entry-title',
		'render_callback'     => 'business_park_customize_partial_portfolio_title',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
	) );
}

// Add portfolio padding title setting and control.
$wp_customize->add_setting( 'business_park_theme_options[portfolio_padding]', array(
	'default'           => $options['portfolio_padding'],
	'transport'         => 'refresh',
	'sanitize_callback' => 'absint'
) );

$wp_customize->add_control( 'business_park_theme_options[portfolio_padding]', array(
	'label'           => esc_html__( 'Padding ( in px )', 'business-park-pro' ),
	'description'           => esc_html__( 'This will increase spacing between images.', 'business-park-pro' ),
	'section'         => 'business_park_portfolio_section',
	'type'            => 'number',
	'active_callback' => 'business_park_is_portfolio_active',
) );

// Add portfolio content type setting and control.
$wp_customize->add_setting( 'business_park_theme_options[portfolio_content_type]', array(
	'default'           => $options['portfolio_content_type'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[portfolio_content_type]', array(
	'label'           => esc_html__( 'Content Type', 'business-park-pro' ),
	'section'         => 'business_park_portfolio_section',
	'type'            => 'select',
	'active_callback' => 'business_park_is_portfolio_active',
	'choices'         => business_park_portfolio_content_type()
) );

if ( business_park_is_jetpack_cpt_module_enable( 'jetpack_portfolio' ) ) {
	// Show taxonomy drop-down setting and control
	$wp_customize->add_setting( 'business_park_theme_options[portfolio_category_1]', array(
		'sanitize_callback' => 'business_park_sanitize_jetpack_project_type_list'
	) );

	$wp_customize->add_control( new Business_Park_Dropdown_Multiple_Taxonomies_Control( $wp_customize, 'business_park_theme_options[portfolio_category_1]', array(
		'label'           => esc_html__( 'Porfolio Category', 'business-park-pro' ),
		'section'         => 'business_park_portfolio_section',
		'active_callback' => 'business_park_is_portfolio_category_active',
		'type'				=> 'dropdown-taxonomies-multiple',
		'taxonomy'       	=> 'jetpack-portfolio-type'
	) ) );
}

/**
 * Content type: Catgory
*/
// Show category type setting and control
$wp_customize->add_setting( 'business_park_theme_options[portfolio_content_category]', array(
	'sanitize_callback' => 'business_park_sanitize_category_list'
) );

$wp_customize->add_control( new Business_Park_Dropdown_Multiple_Taxonomies_Control( $wp_customize, 'business_park_theme_options[portfolio_content_category]', array(
	'label'           => esc_html__( 'Category', 'business-park-pro' ),
	'description'     => esc_html__( 'Select the category to be shown as portfolio.', 'business-park-pro' ),
	'section'         => 'business_park_portfolio_section',
	'active_callback' => 'business_park_is_portfolio_content_cat_active',
) ) );
