<?php
/**
 * Pricing Customizer options
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */


// Add about enable section
$wp_customize->add_section( 'business_park_pricing_section', array(
	'title'             => esc_html__( 'Pricing','business-park-pro'),
	'description'       => esc_html__( 'Pricing section options.', 'business-park-pro' ),
	'panel'             => 'business_park_sections_panel'
) );

// Add about enable setting and control.
$wp_customize->add_setting( 'business_park_theme_options[pricing_enable]', array(
	'default'           => $options['pricing_enable'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[pricing_enable]', array(
	'label'             => esc_html__( 'Enable on', 'business-park-pro' ),
	'section'           => 'business_park_pricing_section',
	'type'              => 'select',
	'choices'           => business_park_enable_options()
) );

// Show pricing section title setting and control
$wp_customize->add_setting( 'business_park_theme_options[pricing_section_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			  => $options['pricing_section_title'],
	'transport'			  => 'postMessage'
) );

$wp_customize->add_control( 'business_park_theme_options[pricing_section_title]', array(
	'label'           => esc_html__( 'Section Title', 'business-park-pro' ),
	'section'         => 'business_park_pricing_section',
	'active_callback' => 'business_park_is_pricing_active',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial( 'business_park_theme_options[pricing_section_title]', array(
		'selector'            => '#pricing h2.entry-title',
		'render_callback'     => 'business_park_customize_partial_pricing_title',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
	) );
}

// Add pricing bg-image setting and control.
$wp_customize->add_setting( 'business_park_theme_options[pricing_bg_image]', array(
	'default'           => $options['pricing_bg_image'],
	'sanitize_callback' => 'business_park_sanitize_image',
) );

$wp_customize->add_control( new WP_Customize_Image_Control ( $wp_customize, 'business_park_theme_options[pricing_bg_image]', array(
	'label'           => esc_html__( 'Background Image', 'business-park-pro' ),
	'description'     => esc_html__( 'Note: When the image is removed, the default image will be used.', 'business-park-pro' ),
	'section'         => 'business_park_pricing_section',
	'active_callback' => 'business_park_is_pricing_active',
) ) );

// Add pricing content type setting and control.
$wp_customize->add_setting( 'business_park_theme_options[pricing_content_type]', array(
	'default'           => $options['pricing_content_type'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[pricing_content_type]', array(
	'label'           => esc_html__( 'Content Type', 'business-park-pro' ),
	'section'         => 'business_park_pricing_section',
	'type'            => 'select',
	'active_callback' => 'business_park_is_pricing_active',
	'choices'         => business_park_pricing_content_type()
) );

// Add pie chart number setting and control.
$wp_customize->add_setting( 'business_park_theme_options[pricing_count]', array(
	'default'           => $options['pricing_count'],
	'sanitize_callback' => 'business_park_sanitize_number_range'
) );

$wp_customize->add_control( 'business_park_theme_options[pricing_count]', array(
	'label'           => esc_html__( 'Number of Pricing blocks', 'business-park-pro' ),
	'description'     => esc_html__( 'Notice: Please refresh after the number of slides is set to see the effects.', 'business-park-pro' ),
	'section'         => 'business_park_pricing_section',
	'type'            => 'number',
	'active_callback' => 'business_park_is_pricing_content_demo_inactive',
	'input_attrs'     => array(
		'max' => 4,
		'min' => 1
	)
) );

for ( $i=1; $i <= $options['pricing_count']; $i++ ) {
	// Show post type setting and control
	$wp_customize->add_setting( 'business_park_theme_options[pricing_content_post_'.$i.']', array(
		'sanitize_callback' => 'business_park_sanitize_number_range'
	) );

	$wp_customize->add_control( 'business_park_theme_options[pricing_content_post_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Pricing Post #%s', 'business-park-pro' ), $i ),
		'description'           => esc_html__( 'Enter the Post ID here.', 'business-park-pro' ),
		'section'         => 'business_park_pricing_section',
		'active_callback' => 'business_park_is_pricing_content_post_active',
		'type'				=> 'number',
		'input_attrs'     => array(
			'min'	=> 0
			)
	) );
}