<?php
/**
 * Service Customizer options
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */


// Add service enable section
$wp_customize->add_section( 'business_park_service_section', array(
	'title'             => esc_html__( 'Service','business-park-pro' ),
	'description'       => esc_html__( 'Service section options.', 'business-park-pro' ),
	'panel'             => 'business_park_sections_panel'
) );

// Add service enable setting and control.
$wp_customize->add_setting( 'business_park_theme_options[service_enable]', array(
	'default'           => $options['service_enable'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[service_enable]', array(
	'label'             => esc_html__( 'Enable on', 'business-park-pro' ),
	'section'           => 'business_park_service_section',
	'type'              => 'select',
	'choices'           => business_park_enable_options()
) );

// Show service section title setting and control
$wp_customize->add_setting( 'business_park_theme_options[service_section_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			  => $options['service_section_title'],
	'transport'			  => 'postMessage'
) );

$wp_customize->add_control( 'business_park_theme_options[service_section_title]', array(
	'label'           => esc_html__( 'Section Title', 'business-park-pro' ),
	'section'         => 'business_park_service_section',
	'active_callback' => 'business_park_is_service_active',
	'type'				=> 'text'
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial( 'business_park_theme_options[service_section_title]', array(
		'selector'            => '#services h2.entry-title',
		'render_callback'     => 'business_park_customize_partial_service_title',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
	) );
}

// Add service content type setting and control.
$wp_customize->add_setting( 'business_park_theme_options[service_content_type]', array(
	'default'           => $options['service_content_type'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[service_content_type]', array(
	'label'           => esc_html__( 'Content Type', 'business-park-pro' ),
	'section'         => 'business_park_service_section',
	'type'            => 'select',
	'active_callback' => 'business_park_is_service_active',
	'choices'         => business_park_pricing_content_type()
) );

// Add service number setting and control.
$wp_customize->add_setting( 'business_park_theme_options[service_content_count]', array(
	'default'           => $options['service_content_count'],
	'sanitize_callback' => 'business_park_sanitize_number_range'
) );

$wp_customize->add_control( 'business_park_theme_options[service_content_count]', array(
	'label'           => esc_html__( 'Number of service', 'business-park-pro' ),
	'description'     => esc_html__( 'Notice: Please refresh after the number of services is set to see the effects.', 'business-park-pro' ),
	'section'         => 'business_park_service_section',
	'type'            => 'number',
	'active_callback' => 'business_park_is_service_content_demo_inactive',
	'input_attrs'     => array(
		'max' => 13,
		'min' => 1
	)
) );

/*
* Post Content Type
 */
for ($i=1; $i <= $options['service_content_count']; $i++) {
	// Show service icon setting and control
	$wp_customize->add_setting( 'business_park_theme_options[service_icon_'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( 'business_park_theme_options[service_icon_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Icon #%s', 'business-park-pro' ), $i ),
		'section'         => 'business_park_service_section',
		'active_callback' => 'business_park_is_service_content_demo_inactive',
		'type'				=> 'text',
		'input_attrs'		=> array( 'placeholder'		=> 'fa-archive' )
	) );

	// Show service icon color setting and control
	$wp_customize->add_setting( 'business_park_theme_options[service_icon_color_'.$i.']', array(
		'sanitize_callback' => 'sanitize_hex_color',
		'default'			  => '#009999'
	) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'business_park_theme_options[service_icon_color_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Icon Background Color #%s', 'business-park-pro' ), $i ),
		'section'         => 'business_park_service_section',
		'active_callback' => 'business_park_is_service_content_demo_inactive',
	) ) );

	// Show post type setting and control
	$wp_customize->add_setting( 'business_park_theme_options[service_content_post_'.$i.']', array(
		'sanitize_callback' => 'business_park_sanitize_number_range'
	) );

	$wp_customize->add_control( 'business_park_theme_options[service_content_post_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Post Service #%s', 'business-park-pro' ), $i ),
		'description'           => esc_html__( 'Enter the Post ID here.', 'business-park-pro' ),
		'section'         => 'business_park_service_section',
		'active_callback' => 'business_park_is_service_post_content_active',
		'type'				=> 'number',
		'input_attrs'     => array(
			'min'	=> 0
			)
	) );

	// Show page drop-down setting and control
	$wp_customize->add_setting( 'business_park_theme_options[service_content_page_'.$i.']', array(
		'sanitize_callback' => 'business_park_sanitize_page'
	) );

	$wp_customize->add_control( 'business_park_theme_options[service_content_page_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Page Service #%s', 'business-park-pro' ), $i ),
		'section'         => 'business_park_service_section',
		'active_callback' => 'business_park_is_service_page_content_active',
		'type'				=> 'dropdown-pages'
	) );

	// Service custom hr setting and control
	$wp_customize->add_setting( 'business_park_theme_options[service_content_custom_hr'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Business_Park_Customize_Horizontal_Line( $wp_customize, 'business_park_theme_options[service_content_custom_hr'.$i.']',
		array(
			'section'         => 'business_park_service_section',
			'active_callback' => 'business_park_is_service_content_demo_inactive',
			'type'				=> 'hr'
	) ) );
}