<?php
/**
 * Slider Customizer options
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */


// Add slider enable section
$wp_customize->add_section( 'business_park_slider_section', array(
	'title'             => esc_html__( 'Slider','business-park-pro' ),
	'description'       => esc_html__( 'Slider section options.', 'business-park-pro' ),
	'panel'             => 'business_park_sections_panel'
) );

// Add slider enable setting and control.
$wp_customize->add_setting( 'business_park_theme_options[slider_enable]', array(
	'default'           => $options['slider_enable'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[slider_enable]', array(
	'label'             => esc_html__( 'Enable on', 'business-park-pro' ),
	'section'           => 'business_park_slider_section',
	'type'              => 'select',
	'choices'           => business_park_enable_options()
) );

// Add slider effects setting and control.
$wp_customize->add_setting( 'business_park_theme_options[slider_content_effect]', array(
	'default'           => $options['slider_content_effect'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[slider_content_effect]', array(
	'label'           => esc_html__( 'Transition Effects', 'business-park-pro' ),
	'section'         => 'business_park_slider_section',
	'type'            => 'select',
	'active_callback' => 'business_park_is_slider_active',
	'choices'         => business_park_slider_effect(),
) );

// Add enable slider captions setting and control.
$wp_customize->add_setting( 'business_park_theme_options[enable_slider_captions]', array(
	'default'           => $options['enable_slider_captions'],
	'sanitize_callback' => 'business_park_sanitize_checkbox'
) );

$wp_customize->add_control( 'business_park_theme_options[enable_slider_captions]', array(
	'label'           => esc_html__( 'Enable slider captions', 'business-park-pro' ),
	'section'         => 'business_park_slider_section',
	'type'            => 'checkbox',
	'active_callback' => 'business_park_is_slider_active',
) );

// Add enable arrow controls setting and control.
$wp_customize->add_setting( 'business_park_theme_options[enable_arrow_controls]', array(
	'default'           => $options['enable_arrow_controls'],
	'sanitize_callback' => 'business_park_sanitize_checkbox'
) );

$wp_customize->add_control( 'business_park_theme_options[enable_arrow_controls]', array(
	'label'           => esc_html__( 'Enable arrow controls', 'business-park-pro' ),
	'section'         => 'business_park_slider_section',
	'type'            => 'checkbox',
	'active_callback' => 'business_park_is_slider_active',
) );

// Add enable slider pager setting and control.
$wp_customize->add_setting( 'business_park_theme_options[enable_slider_pager]', array(
	'default'           => $options['enable_slider_pager'],
	'sanitize_callback' => 'business_park_sanitize_checkbox'
) );

$wp_customize->add_control( 'business_park_theme_options[enable_slider_pager]', array(
	'label'           => esc_html__( 'Enable pager controls', 'business-park-pro' ),
	'section'         => 'business_park_slider_section',
	'type'            => 'checkbox',
	'active_callback' => 'business_park_is_slider_active',
) );

// Add enable slider pager setting and control.
$wp_customize->add_setting( 'business_park_theme_options[enable_slider_progress_bar]', array(
	'default'           => $options['enable_slider_progress_bar'],
	'sanitize_callback' => 'business_park_sanitize_checkbox'
) );

$wp_customize->add_control( 'business_park_theme_options[enable_slider_progress_bar]', array(
	'label'           => esc_html__( 'Enable progress bar', 'business-park-pro' ),
	'section'         => 'business_park_slider_section',
	'type'            => 'checkbox',
	'active_callback' => 'business_park_is_slider_active',
) );

// Add slider content type setting and control.
$wp_customize->add_setting( 'business_park_theme_options[slider_content_type]', array(
	'default'           => $options['slider_content_type'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[slider_content_type]', array(
	'label'           => esc_html__( 'Content Type', 'business-park-pro' ),
	'section'         => 'business_park_slider_section',
	'type'            => 'select',
	'active_callback' => 'business_park_is_slider_active',
	'choices'         => business_park_content_type()
) );

// Add slider number setting and control.
$wp_customize->add_setting( 'business_park_theme_options[slider_content_page_count]', array(
	'default'           => $options['slider_content_page_count'],
	'sanitize_callback' => 'business_park_sanitize_number_range'
) );

$wp_customize->add_control( 'business_park_theme_options[slider_content_page_count]', array(
	'label'           => esc_html__( 'Number of slides', 'business-park-pro' ),
	'description'     => esc_html__( 'Notice: Please refresh after the number of slides is set to see the effects.', 'business-park-pro' ),
	'section'         => 'business_park_slider_section',
	'type'            => 'number',
	'active_callback' => 'business_park_is_slider_content_type_active',
	'input_attrs'     => array(
		'max' => 4,
		'min' => 1
	)
) );

// Add slider read more text setting and control.
$wp_customize->add_setting( 'business_park_theme_options[slider_content_read_more_text]', array(
	'default'           => $options['slider_content_read_more_text'],
	'sanitize_callback' => 'sanitize_text_field'
) );

$wp_customize->add_control( 'business_park_theme_options[slider_content_read_more_text]', array(
	'label'           => esc_html__( 'Read More Text:', 'business-park-pro' ),
	'description'     => esc_html__( 'Notice: Keep it empty to remove it.', 'business-park-pro' ),
	'section'         => 'business_park_slider_section',
	'type'            => 'text',
	'active_callback' => 'business_park_is_slider_content_type_active',
) );

/**
 * Page Content Type
 */
for ($i=1; $i <= $options['slider_content_page_count']; $i++) {
	// Show page drop-down setting and control
	$wp_customize->add_setting( 'business_park_theme_options[slider_content_page_'.$i.']', array(
		'sanitize_callback' => 'business_park_sanitize_page'
	) );

	$wp_customize->add_control( 'business_park_theme_options[slider_content_page_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Page Slider #%s', 'business-park-pro' ), $i ),
		'section'         => 'business_park_slider_section',
		'active_callback' => 'business_park_is_slider_page_content_active',
		'type'				=> 'dropdown-pages'
	) );

	// Slider page icons setting and control
	$wp_customize->add_setting( 'business_park_theme_options[slider_content_page_icon_'.$i.']', array(
		'sanitize_callback' => 'business_park_sanitize_image'
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'business_park_theme_options[slider_content_page_icon_'.$i.']',
		array(
			'label'           => sprintf( esc_html__( 'Page Slider Icon #%s', 'business-park-pro' ), $i ),
			'description'     => esc_html__( 'The recommended size for the icon is 120px by 70px.', 'business-park-pro' ),
			'button_labels'   => array(
				'placeholder'     => esc_attr__( 'No image selected', 'business-park-pro' ),
				'select'          => esc_html__( 'Select Icon', 'business-park-pro' ),
				'change'          => esc_html__( 'Change Icon', 'business-park-pro' ),
				'frame_title'     => esc_html__( 'Select Icon', 'business-park-pro' ),
				'frame_button'    => esc_html__( 'Choose Icon', 'business-park-pro' ),
			),
			'section'         => 'business_park_slider_section',
			'active_callback' => 'business_park_is_slider_page_content_active',
	) ) );

	// Slider page hr setting and control
	$wp_customize->add_setting( 'business_park_theme_options[slider_content_page_hr'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Business_Park_Customize_Horizontal_Line( $wp_customize, 'business_park_theme_options[slider_content_page_hr'.$i.']',
		array(
			'section'         => 'business_park_slider_section',
			'active_callback' => 'business_park_is_slider_page_content_active',
			'type'				=> 'hr'
	) ) );
}

/*
* Post Content Type
 */
for ($i=1; $i <= $options['slider_content_page_count']; $i++) {
	// Show post type setting and control
	$wp_customize->add_setting( 'business_park_theme_options[slider_content_post_'.$i.']', array(
		'sanitize_callback' => 'business_park_sanitize_number_range'
	) );

	$wp_customize->add_control( 'business_park_theme_options[slider_content_post_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Post Slider #%s', 'business-park-pro' ), $i ),
		'description'           => esc_html__( 'Enter the Post ID here.', 'business-park-pro' ),
		'section'         => 'business_park_slider_section',
		'active_callback' => 'business_park_is_slider_post_content_active',
		'type'				=> 'number',
		'input_attrs'     => array(
			'min'	=> 0
			)
	) );

	// Slider post icons setting and control
	$wp_customize->add_setting( 'business_park_theme_options[slider_content_page_icon_'.$i.']', array(
		'sanitize_callback' => 'business_park_sanitize_image'
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'business_park_theme_options[slider_content_page_icon_'.$i.']',
		array(
			'label'           => sprintf( esc_html__( 'Post Slider Icon #%s', 'business-park-pro' ), $i ),
			'description'     => esc_html__( 'The recommended size for the icon is 120px by 70px.', 'business-park-pro' ),
			'button_labels'   => array(
				'placeholder'     => esc_attr__( 'No image selected', 'business-park-pro' ),
				'select'          => esc_html__( 'Select Icon', 'business-park-pro' ),
				'change'          => esc_html__( 'Change Icon', 'business-park-pro' ),
				'frame_title'     => esc_html__( 'Select Icon', 'business-park-pro' ),
				'frame_button'    => esc_html__( 'Choose Icon', 'business-park-pro' ),
			),
			'section'         => 'business_park_slider_section',
			'active_callback' => 'business_park_is_slider_post_content_active',
	) ) );

	// Slider post hr setting and control
	$wp_customize->add_setting( 'business_park_theme_options[slider_content_post_hr'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Business_Park_Customize_Horizontal_Line( $wp_customize, 'business_park_theme_options[slider_content_post_hr'.$i.']',
		array(
			'section'         => 'business_park_slider_section',
			'active_callback' => 'business_park_is_slider_post_content_active',
			'type'				=> 'hr'
	) ) );
}

/**
 * Custom content type
 */
for ($i=1; $i <= $options['slider_content_page_count']; $i++) {
	// Show title setting and control
	$wp_customize->add_setting( 'business_park_theme_options[slider_content_custom_title_'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( 'business_park_theme_options[slider_content_custom_title_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Title #%s', 'business-park-pro' ), $i ),
		'section'         => 'business_park_slider_section',
		'active_callback' => 'business_park_is_slider_custom_content_active',
		'type'				=> 'text'
	) );

	// Show description setting and control
	$wp_customize->add_setting( 'business_park_theme_options[slider_content_custom_desc_'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( 'business_park_theme_options[slider_content_custom_desc_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Description #%s', 'business-park-pro' ), $i ),
		'section'         => 'business_park_slider_section',
		'active_callback' => 'business_park_is_slider_custom_content_active',
		'type'				=> 'textarea'
	) );

	// Show image setting and control
	$wp_customize->add_setting( 'business_park_theme_options[slider_content_custom_image_'.$i.']', array(
		'sanitize_callback' => 'business_park_sanitize_image'
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'business_park_theme_options[slider_content_custom_image_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Custom Slider Image #%s', 'business-park-pro' ), $i ),
		'description'     => esc_html__( 'The recommended size for the image is 1920px by 1080px.', 'business-park-pro' ),
		'section'         => 'business_park_slider_section',
		'active_callback' => 'business_park_is_slider_custom_content_active',
	) ) );

	// Show url setting and control
	$wp_customize->add_setting( 'business_park_theme_options[slider_content_custom_url_'.$i.']', array(
		'sanitize_callback' => 'esc_url'
	) );

	$wp_customize->add_control( 'business_park_theme_options[slider_content_custom_url_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'URL #%s', 'business-park-pro' ), $i ),
		'section'         => 'business_park_slider_section',
		'active_callback' => 'business_park_is_slider_custom_content_active',
		'type'				=> 'url'
	) );

	// Slider custom icons setting and control
	$wp_customize->add_setting( 'business_park_theme_options[slider_content_custom_icon_'.$i.']', array(
		'sanitize_callback' => 'business_park_sanitize_image'
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'business_park_theme_options[slider_content_custom_icon_'.$i.']',
		array(
			'label'           => sprintf( esc_html__( 'Custom Slider Icon #%s', 'business-park-pro' ), $i ),
			'description'     => esc_html__( 'The recommended size for the icon is 120px by 70px.', 'business-park-pro' ),
			'button_labels'   => array(
				'placeholder'     => esc_attr__( 'No image selected', 'business-park-pro' ),
				'select'          => esc_html__( 'Select Icon', 'business-park-pro' ),
				'change'          => esc_html__( 'Change Icon', 'business-park-pro' ),
				'frame_title'     => esc_html__( 'Select Icon', 'business-park-pro' ),
				'frame_button'    => esc_html__( 'Choose Icon', 'business-park-pro' ),
			),
			'section'         => 'business_park_slider_section',
			'active_callback' => 'business_park_is_slider_custom_content_active',
	) ) );

	// Slider custom hr setting and control
	$wp_customize->add_setting( 'business_park_theme_options[slider_content_custom_hr'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Business_Park_Customize_Horizontal_Line( $wp_customize, 'business_park_theme_options[slider_content_custom_hr'.$i.']',
		array(
			'section'         => 'business_park_slider_section',
			'active_callback' => 'business_park_is_slider_custom_content_active',
			'type'				=> 'hr'
	) ) );
}