<?php
/**
 * Team Customizer options
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */

// Add team enable section
$wp_customize->add_section( 'business_park_team_section', array(
	'title'             => esc_html__( 'Team','business-park-pro' ),
	'description'       => esc_html__( 'Team section options.', 'business-park-pro' ),
	'panel'             => 'business_park_sections_panel'
) );

// Add team enable setting and control.
$wp_customize->add_setting( 'business_park_theme_options[team_enable]', array(
	'default'           => $options['team_enable'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[team_enable]', array(
	'label'             => esc_html__( 'Enable on', 'business-park-pro' ),
	'section'           => 'business_park_team_section',
	'type'              => 'select',
	'choices'           => business_park_enable_options()
) );

// Show section title setting and control
$wp_customize->add_setting( 'business_park_theme_options[team_section_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'transport'			  => 'postMessage',
	'default'           => $options['team_section_title'],
) );

$wp_customize->add_control( 'business_park_theme_options[team_section_title]', array(
	'label'           => esc_html__( 'Title', 'business-park-pro' ),
	'section'         => 'business_park_team_section',
	'active_callback' => 'business_park_is_team_active',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial( 'business_park_theme_options[team_section_title]', array(
		'selector'            => '#team h2.entry-title',
		'render_callback'     => 'business_park_customize_team_section_title',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
	) );
}

// Add team bg-image setting and control.
$wp_customize->add_setting( 'business_park_theme_options[team_bg_image]', array(
	'default'           => $options['team_bg_image'],
	'sanitize_callback' => 'business_park_sanitize_image',
) );

$wp_customize->add_control( new WP_Customize_Image_Control ( $wp_customize, 'business_park_theme_options[team_bg_image]', array(
	'label'           => esc_html__( 'Background Image', 'business-park-pro' ),
	'description'     => esc_html__( 'Note: When the image is removed, the default image will be used.', 'business-park-pro' ),
	'section'         => 'business_park_team_section',
	'active_callback' => 'business_park_is_team_active',
) ) );

// Add team content type setting and control.
$wp_customize->add_setting( 'business_park_theme_options[team_content_type]', array(
	'default'           => $options['team_content_type'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[team_content_type]', array(
	'label'           => esc_html__( 'Content Type', 'business-park-pro' ),
	'section'         => 'business_park_team_section',
	'type'            => 'select',
	'active_callback' => 'business_park_is_team_active',
	'choices'         => business_park_team_content_type(),
) );

// Add team number setting and control.
$wp_customize->add_setting( 'business_park_theme_options[team_content_count]', array(
	'default'           => $options['team_content_count'],
	'sanitize_callback' => 'business_park_sanitize_number_range'
) );

$wp_customize->add_control( 'business_park_theme_options[team_content_count]', array(
	'label'           => esc_html__( 'Number of team members', 'business-park-pro' ),
	'description'     => esc_html__( 'Notice: Please refresh after the number of team member is set to see the effects.', 'business-park-pro' ),
	'section'         => 'business_park_team_section',
	'type'            => 'number',
	'active_callback' => 'business_park_is_team_content_type_active',
	'input_attrs'     => array(
		'max' => 4,
		'min' => 1
	)
) );


for ($i=1; $i <= $options['team_content_count']; $i++) {
	/*
	* Post Content Type
	*/
	// Show post type setting and control
	$wp_customize->add_setting( 'business_park_theme_options[team_content_post_'.$i.']', array(
		'sanitize_callback' => 'business_park_sanitize_number_range'
	) );

	$wp_customize->add_control( 'business_park_theme_options[team_content_post_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Team Post #%s', 'business-park-pro' ), $i ),
		'description'           => esc_html__( 'Enter the Post ID here.', 'business-park-pro' ),
		'section'         => 'business_park_team_section',
		'active_callback' => 'business_park_is_team_post_content_active',
		'type'				=> 'number',
		'input_attrs'     => array(
			'min'	=> 0
			)
	) );

	/**
	 * Page Content Type
	 */
	// Show page drop-down setting and control
	$wp_customize->add_setting( 'business_park_theme_options[team_content_page_'.$i.']', array(
		'sanitize_callback' => 'business_park_sanitize_page'
	) );

	$wp_customize->add_control( 'business_park_theme_options[team_content_page_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Team Page #%s', 'business-park-pro' ), $i ),
		'section'         => 'business_park_team_section',
		'active_callback' => 'business_park_is_team_page_content_active',
		'type'				=> 'dropdown-pages'
	) );

	// Show team position setting and control
	$wp_customize->add_setting( 'business_park_theme_options[team_position_'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'business_park_theme_options[team_position_'.$i.']', array(
		'label'           => esc_html__( 'Position', 'business-park-pro' ),
		'section'         => 'business_park_team_section',
		'active_callback' => 'business_park_is_team_demo_content_inactive',
		'type'				=> 'text',
	) );

	// Show social icons setting and control
	$wp_customize->add_setting( 'business_park_theme_options[team_facebook_'.$i.']', array(
		'sanitize_callback' => 'esc_url'
	) );

	$wp_customize->add_control( 'business_park_theme_options[team_facebook_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Facebook #%s', 'business-park-pro' ), $i ),
		'section'         => 'business_park_team_section',
		'active_callback' => 'business_park_is_team_demo_content_inactive',
		'type'       		=> 'url'
	) );

	// Show social icons setting and control
	$wp_customize->add_setting( 'business_park_theme_options[team_twitter_'.$i.']', array(
		'sanitize_callback' => 'esc_url'
	) );

	$wp_customize->add_control( 'business_park_theme_options[team_twitter_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Twitter #%s', 'business-park-pro' ), $i ),
		'section'         => 'business_park_team_section',
		'active_callback' => 'business_park_is_team_demo_content_inactive',
		'type'       		=> 'url'
	) );

	// Show social icons setting and control
	$wp_customize->add_setting( 'business_park_theme_options[team_linkedin_'.$i.']', array(
		'sanitize_callback' => 'esc_url'
	) );

	$wp_customize->add_control( 'business_park_theme_options[team_linkedin_'.$i.']', array(
		'label'           => sprintf( esc_html__( 'Linkedin #%s', 'business-park-pro' ), $i ),
		'section'         => 'business_park_team_section',
		'active_callback' => 'business_park_is_team_demo_content_inactive',
		'type'       		=> 'url'
	) );

	// Slider post hr setting and control
	$wp_customize->add_setting( 'business_park_theme_options[team_content_post_hr'.$i.']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new Business_Park_Customize_Horizontal_Line( $wp_customize, 'business_park_theme_options[team_content_post_hr'.$i.']',
		array(
			'section'         => 'business_park_team_section',
			'active_callback' => 'business_park_is_team_demo_content_inactive',
			'type'				=> 'hr'
	) ) );
}


