<?php
/**
 * Testimonial Customizer options
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */

// Add testimonial enable section
$wp_customize->add_section( 'business_park_testimonial_section', array(
	'title'             => esc_html__( 'Testimonial','business-park-pro'),
	'description'       => sprintf( esc_html__( 'Testimonial Content Type Option requires %1$sJetPack%2$s Plugin with Custom Content Types module Enabled and checked at %3$sSettings ->Writing%4$s.', 'business-park-pro' ), '<a target="_blank" href="'.esc_url( 'https://wordpress.org/plugins/jetpack/' ).'">', '</a>', '<a target="_blank" href="'. esc_url( admin_url('options-writing.php') ).'">', '</a>' ),
	'panel'             => 'business_park_sections_panel'
) );

// Add testimonial enable setting and control.
$wp_customize->add_setting( 'business_park_theme_options[testimonial_enable]', array(
	'default'           => $options['testimonial_enable'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[testimonial_enable]', array(
	'label'             => esc_html__( 'Enable on', 'business-park-pro' ),
	'section'           => 'business_park_testimonial_section',
	'type'              => 'select',
	'choices'           => business_park_enable_options()
) );

// Add testimonial title setting and control.
$wp_customize->add_setting( 'business_park_theme_options[testimonial_title]', array(
	'default'           => $options['testimonial_title'],
	'sanitize_callback' => 'sanitize_text_field',
	'transport'         => 'postMessage',
) );

$wp_customize->add_control( 'business_park_theme_options[testimonial_title]', array(
	'label'           => esc_html__( 'Title', 'business-park-pro' ),
	'section'         => 'business_park_testimonial_section',
	'type'            => 'text',
	'active_callback' => 'business_park_is_testimonial_active',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial( 'business_park_theme_options[testimonial_title]', array(
		'selector'            => '#client-carousel h2.entry-title',
		'render_callback'     => 'business_park_customize_partial_testimonial_title',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
	) );
}

// Add testimonial background setting and control.
$wp_customize->add_setting( 'business_park_theme_options[testimonial_background_type]', array(
	'default'           => $options['testimonial_background_type'],
	'sanitize_callback' => 'business_park_sanitize_select',
) );

$wp_customize->add_control( 'business_park_theme_options[testimonial_background_type]', array(
	'label'           => esc_html__( 'Background', 'business-park-pro' ),
	'description'     => esc_html__( 'Choose the type of background to be used.', 'business-park-pro' ),
	'section'         => 'business_park_testimonial_section',
	'active_callback' => 'business_park_is_testimonial_active',
	'type'				=> 'radio',
	'choices'			=> business_park_testimonial_bg_type(),
) );

// Add testimonial bg-image setting and control.
$wp_customize->add_setting( 'business_park_theme_options[testimonial_bg_image]', array(
	'default'           => $options['testimonial_bg_image'],
	'sanitize_callback' => 'business_park_sanitize_image',
) );

$wp_customize->add_control( new WP_Customize_Image_Control ( $wp_customize, 'business_park_theme_options[testimonial_bg_image]', array(
	'label'           => esc_html__( 'Background Image', 'business-park-pro' ),
	'description'     => esc_html__( 'Note: When the image is removed, the default image will be used.', 'business-park-pro' ),
	'section'         => 'business_park_testimonial_section',
	'active_callback' => 'business_park_is_testimonial_bg_image_active',
) ) );

// Add testimonial bg-video setting and control.
$wp_customize->add_setting( 'business_park_theme_options[testimonial_bg_video]', array(
	'sanitize_callback' => 'absint',
) );

$wp_customize->add_control( new WP_Customize_Media_Control ( $wp_customize, 'business_park_theme_options[testimonial_bg_video]', array(
	'label'           => esc_html__( 'Background Video', 'business-park-pro' ),
	'description'     => esc_html__( 'You can upload a video which will autoplay in background.', 'business-park-pro' ),
	'section'         => 'business_park_testimonial_section',
	'active_callback' => 'business_park_is_testimonial_bg_video_active',
	'button_labels'   => array(
		'select'       => esc_html__( 'Select Video', 'business-park-pro' ),
		'change'       => esc_html__( 'Change Video', 'business-park-pro' ),
		'default'      => esc_html__( 'Default', 'business-park-pro' ),
		'remove'       => esc_html__( 'Remove', 'business-park-pro' ),
		'placeholder'  => esc_attr__( 'No Video selected', 'business-park-pro' ),
		'frame_title'  => esc_html__( 'Select Video', 'business-park-pro' ),
		'frame_button' => esc_html__( 'Choose Video', 'business-park-pro' ),
		),
	'mime_type' 		=> 'video'
) ) );

// Add testimonial caption setting and control.
$wp_customize->add_setting( 'business_park_theme_options[testimonial_caption]', array(
	'default'           => $options['testimonial_caption'],
	'sanitize_callback' => 'business_park_sanitize_checkbox',
) );

$wp_customize->add_control( 'business_park_theme_options[testimonial_caption]', array(
	'label'           => esc_html__( 'Enable background on caption.', 'business-park-pro' ),
	'section'         => 'business_park_testimonial_section',
	'active_callback' => 'business_park_is_testimonial_active',
	'type'				=> 'checkbox',
) );

// Add testimonial content type setting and control.
$wp_customize->add_setting( 'business_park_theme_options[testimonial_content_type]', array(
	'default'           => $options['testimonial_content_type'],
	'sanitize_callback' => 'business_park_sanitize_select'
) );

$wp_customize->add_control( 'business_park_theme_options[testimonial_content_type]', array(
	'label'           => esc_html__( 'Content Type', 'business-park-pro' ),
	'section'         => 'business_park_testimonial_section',
	'type'            => 'select',
	'active_callback' => 'business_park_is_testimonial_active',
	'choices'         => business_park_testimonial_content_type()
) );

// Add slider number setting and control.
$wp_customize->add_setting( 'business_park_theme_options[testimonial_content_count]', array(
	'default'           => $options['testimonial_content_count'],
	'sanitize_callback' => 'business_park_sanitize_number_range'
) );

$wp_customize->add_control( 'business_park_theme_options[testimonial_content_count]', array(
	'label'           => esc_html__( 'Number of testimonials', 'business-park-pro' ),
	'description'     => esc_html__( 'Notice: Please refresh after the number of slides is set to see the effects.', 'business-park-pro' ),
	'section'         => 'business_park_testimonial_section',
	'type'            => 'number',
	'active_callback' => 'business_park_is_testimonial_content_demo_inactive',
	'input_attrs'     => array(
		'max' => 4,
		'min' => 1
	)
) );

if ( business_park_is_jetpack_cpt_module_enable( 'jetpack_testimonial' ) ) {

	/**
	 * Content type: Testimonial
	 */
	for ( $i=1; $i <= $options['testimonial_content_count']; $i++ ) {
		// Show social icons setting and control
		$wp_customize->add_setting( 'business_park_theme_options[testimonial_content_'.$i.']', array(
			'sanitize_callback' => 'absint'
		) );

		$wp_customize->add_control( new Business_Park_Dropdown_Post_Type_Post_Control( $wp_customize, 'business_park_theme_options[testimonial_content_'.$i.']', array(
			'label'           => sprintf( esc_html__( 'Testimonial #%s', 'business-park-pro' ), $i ),
			'section'         => 'business_park_testimonial_section',
			'active_callback' => 'business_park_is_testimonial_content_active',
			'type'				=> 'dropdown-post-type-posts',
			'post_type'       => 'jetpack-testimonial'
		) ) );

		// Show social icons setting and control
		$wp_customize->add_setting( 'business_park_theme_options[testimonial_facebook_'.$i.']', array(
			'sanitize_callback' => 'esc_url'
		) );

		$wp_customize->add_control( 'business_park_theme_options[testimonial_facebook_'.$i.']', array(
			'label'           => sprintf( esc_html__( 'Facebook #%s', 'business-park-pro' ), $i ),
			'section'         => 'business_park_testimonial_section',
			'active_callback' => 'business_park_is_testimonial_content_active',
			'type'       		=> 'url'
		) );

		// Show social icons setting and control
		$wp_customize->add_setting( 'business_park_theme_options[testimonial_twitter_'.$i.']', array(
			'sanitize_callback' => 'esc_url'
		) );

		$wp_customize->add_control( 'business_park_theme_options[testimonial_twitter_'.$i.']', array(
			'label'           => sprintf( esc_html__( 'Twitter #%s', 'business-park-pro' ), $i ),
			'section'         => 'business_park_testimonial_section',
			'active_callback' => 'business_park_is_testimonial_content_active',
			'type'       		=> 'url'
		) );

		// Show social icons setting and control
		$wp_customize->add_setting( 'business_park_theme_options[testimonial_pinterest_'.$i.']', array(
			'sanitize_callback' => 'esc_url'
		) );

		$wp_customize->add_control( 'business_park_theme_options[testimonial_pinterest_'.$i.']', array(
			'label'           => sprintf( esc_html__( 'Pinterest #%s', 'business-park-pro' ), $i ),
			'section'         => 'business_park_testimonial_section',
			'active_callback' => 'business_park_is_testimonial_content_active',
			'type'       		=> 'url'
		) );

		// Testimonial hr setting and control
		$wp_customize->add_setting( 'business_park_theme_options[testimonial_content_hr_'.$i.']', array(
			'sanitize_callback' => 'sanitize_text_field'
		) );

		$wp_customize->add_control( new Business_Park_Customize_Horizontal_Line( $wp_customize, 'business_park_theme_options[testimonial_content_hr_'.$i.']',
			array(
				'section'         => 'business_park_testimonial_section',
				'active_callback' => 'business_park_is_testimonial_content_active',
				'type'				=> 'hr'
		) ) );
	}
}

/**
 * Content type: Catgory
*/
// Show category type setting and control
$wp_customize->add_setting( 'business_park_theme_options[testimonial_content_category]', array(
	'sanitize_callback' => 'absint'
) );

$wp_customize->add_control( new Business_Park_Dropdown_Taxonomies_Control( $wp_customize, 'business_park_theme_options[testimonial_content_category]', array(
	'label'           => esc_html__( 'Category', 'business-park-pro' ),
	'description'     => esc_html__( 'Select the category to be shown as testomonial.', 'business-park-pro' ),
	'section'         => 'business_park_testimonial_section',
	'active_callback' => 'business_park_is_testimonial_content_cat_active',
) ) );