<?php
/**
 * Top Bar Customizer options
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */

// Add top bar section
$wp_customize->add_section( 'business_park_top_bar_section', array(
	'title'             => esc_html__( 'Top Bar','business-park-pro' ),
	'panel'             => 'business_park_sections_panel'
) );

// Add top bar phone setting and control.
$wp_customize->add_setting( 'business_park_theme_options[top_bar_phone]', array(
	'default'           => $options['top_bar_phone'],
	'sanitize_callback' => 'sanitize_text_field'
) );

$wp_customize->add_control( 'business_park_theme_options[top_bar_phone]', array(
	'label'             => esc_html__( 'Phone Number', 'business-park-pro' ),
	'section'           => 'business_park_top_bar_section',
	'type'              => 'text',
) );

// Add top bar email setting and control.
$wp_customize->add_setting( 'business_park_theme_options[top_bar_email]', array(
	'default'           => $options['top_bar_email'],
	'sanitize_callback' => 'sanitize_email'
) );

$wp_customize->add_control( 'business_park_theme_options[top_bar_email]', array(
	'label'             => esc_html__( 'Email', 'business-park-pro' ),
	'section'           => 'business_park_top_bar_section',
	'type'              => 'email',
) );

// Add top bar location setting and control.
$wp_customize->add_setting( 'business_park_theme_options[top_bar_location]', array(
	'default'           => $options['top_bar_location'],
	'sanitize_callback' => 'esc_textarea'
) );

$wp_customize->add_control( 'business_park_theme_options[top_bar_location]', array(
	'label'             => esc_html__( 'Location', 'business-park-pro' ),
	'section'           => 'business_park_top_bar_section',
	'type'              => 'textarea',
) );