<?php
/**
* Blog options
*
* @package Theme Palace
* @subpackage Business_Park_Pro
* @since Business Park Pro 2.0.6
*/

// Add Blog options section
$wp_customize->add_section( 'business_park_blog_options', array(
	'title'       => esc_html__( 'Blog Options','business-park-pro' ),
	'panel'       => 'business_park_theme_options_panel',
	'description' => esc_html__( 'These Options Works On Blog Page Only.', 'business-park-pro' ),
) );
// Disable date setting and control.
$wp_customize->add_setting( 'business_park_theme_options[hide_date]', array(
	'sanitize_callback' => 'business_park_sanitize_checkbox',
	'default'           => $options['hide_date']
) );

$wp_customize->add_control( 'business_park_theme_options[hide_date]', array(
	'label'   => esc_html__( 'Hide Date', 'business-park-pro' ),
	'section' => 'business_park_blog_options',
	'type'    => 'checkbox'
) );
// Disable author setting and control.
$wp_customize->add_setting( 'business_park_theme_options[hide_author]', array(
	'sanitize_callback' => 'business_park_sanitize_checkbox',
	'default'           => $options['hide_author']
) );

$wp_customize->add_control( 'business_park_theme_options[hide_author]', array(
	'label'   => esc_html__( 'Hide Author', 'business-park-pro' ),
	'section' => 'business_park_blog_options',
	'type'    => 'checkbox'
) );

// Disable category setting and control.
$wp_customize->add_setting( 'business_park_theme_options[hide_category]', array(
	'sanitize_callback' => 'business_park_sanitize_checkbox',
	'default'           => $options['hide_category']
) );

$wp_customize->add_control( 'business_park_theme_options[hide_category]', array(
	'label'   => esc_html__( 'Hide Category', 'business-park-pro' ),
	'section' => 'business_park_blog_options',
	'type'    => 'checkbox'
) );

// Disable featured images setting and control.
$wp_customize->add_setting( 'business_park_theme_options[hide_tags]', array(
	'sanitize_callback' => 'business_park_sanitize_checkbox',
	'default'           => $options['hide_tags']
) );

$wp_customize->add_control( 'business_park_theme_options[hide_tags]', array(
	'label'   => esc_html__( 'Hide Tags', 'business-park-pro' ),
	'section' => 'business_park_blog_options',
	'type'    => 'checkbox'
) );