<?php
/**
 * Breadcrumb Customizer options
 *
 * @package Theme Palace
 * @subpackage Business_Park_Pro
 * @since Business Park Pro 2.0.0
 */

// Breadcrumb Option
	$wp_customize->add_section( 'business_park_breadcumb_options', array(
		'description'	=> esc_html__( 'Breadcrumbs are a great way of letting your visitors find out where they are on your site with just a glance. You can enable/disable them on homepage and entire site.', 'business-park-pro' ),
		'panel'			=> 'business_park_theme_options_panel',
		'title'    		=> esc_html__( 'Breadcrumb Options', 'business-park-pro' ),
		'priority' 		=> 201,
	) );

	$wp_customize->add_setting( 'business_park_theme_options[breadcumb_option]', array(
		'capability'		=> 'edit_theme_options',
		'default'			=> $options['breadcumb_option'],
		'sanitize_callback' => 'business_park_sanitize_checkbox'
	) );

	$wp_customize->add_control( 'business_park_theme_options[breadcumb_option]', array(
		'label'    => esc_html__( 'Check to enable Breadcrumb', 'business-park-pro' ),
		'section'  => 'business_park_breadcumb_options',
		'type'     => 'checkbox',
	) );

	$wp_customize->add_setting( 'business_park_theme_options[breadcumb_onhomepage]', array(
		'capability'		=> 'edit_theme_options',
		'default'			=> $options['breadcumb_onhomepage'],
		'sanitize_callback' => 'business_park_sanitize_checkbox'
	) );

	$wp_customize->add_control( 'business_park_theme_options[breadcumb_onhomepage]', array(
		'label'    => esc_html__( 'Check to enable Breadcrumb on Homepage', 'business-park-pro' ),
		'section'  => 'business_park_breadcumb_options',
		'type'     => 'checkbox',
	) );

	$wp_customize->add_setting( 'business_park_theme_options[breadcumb_seperator]', array(
		'capability'		=> 'edit_theme_options',
		'default'			=> $options['breadcumb_seperator'],
		'sanitize_callback'	=> 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'business_park_theme_options[breadcumb_seperator]', array(
		'input_attrs' => array(
        		'style' => 'width: 40px;'
    		),
    	'label'    	=> esc_html__( 'Separator between Breadcrumbs', 'business-park-pro' ),
		'section' 	=> 'business_park_breadcumb_options',
		'type'     	=> 'text'
		)
	);