<?php
/**
* Homepage (Static ) options
*
* @package Theme Palace
* @subpackage Business_Park_Pro
* @since Business Park Pro 2.0.0
*/

// Add homepage ( static ) section
$wp_customize->add_section( 'business_park_static_frontpage', array(
	'title'               => esc_html__( 'Homepage ( Static )','business-park-pro' ),
	'description'         => esc_html__( 'Homepage ( Static ) section options.', 'business-park-pro' ),
	'panel'               => 'business_park_theme_options_panel'
) );

// Homepage (Static ) setting and control.
$wp_customize->add_setting( 'business_park_theme_options[enable_frontpage_content]', array(
	'sanitize_callback'   => 'business_park_sanitize_checkbox',
	'default'             => $options['enable_frontpage_content']
) );

$wp_customize->add_control( 'business_park_theme_options[enable_frontpage_content]', array(
	'label'       => esc_html__( 'Enable Content', 'business-park-pro' ),
	'description' => esc_html__( 'Check to enable content on static front page only.', 'business-park-pro' ),
	'section'     => 'business_park_static_frontpage',
	'type'        => 'checkbox'
) );